package cn.com.duiba.activity.center.biz.service.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.hdtool.DuibaHdtoolOptionsDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolOptionsEntity;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolOptionsService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Created by wenqi.huang on 16/5/20.
 */
@Service
public class DuibaHdtoolOptionsServiceImpl implements DuibaHdtoolOptionsService {
    @Resource
    private DuibaHdtoolOptionsDao duibaHdtoolOptionsDao;
    @Resource
    private CacheClient cacheClient;

    private String getDuibaHdtoolOptionsCacheKeyById(Long id){
        return CacheConstants.KEY_DUIBA_HDTOOL_OPTIONS_BY_ID + id;
    }

    private String getDuibaHdtoolOptionsCacheKeyByHdtoolId(Long hdtoolId){
        return CacheConstants.KEY_DUIBA_HDTOOL_OPTIONS_BY_HDTOOL_ID + hdtoolId;
    }

    @Override
    public List<DuibaHdtoolOptionsDto> findByHdtoolId(Long hdtoolId) {
        return BeanUtils.copyList(duibaHdtoolOptionsDao.findByHdtoolId(hdtoolId), DuibaHdtoolOptionsDto.class);
    }

    @Override
    public int addRemainingById(Long id, Integer addRemaining) {
        int ret = duibaHdtoolOptionsDao.addRemainingById(id, addRemaining);
        removeDuibaHdtoolOptionsCacheById(id);
        return ret;
    }

    @Override
    public int subRemainingById(Long id, Integer subRemaining) {
        int ret = duibaHdtoolOptionsDao.subRemainingById(id, subRemaining);
        removeDuibaHdtoolOptionsCacheById(id);
        return ret;
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        int ret = duibaHdtoolOptionsDao.updateRemainingById(id, remaining);
        removeDuibaHdtoolOptionsCacheById(id);
        return ret;
    }

    @Override
    @Transactional(value= DsConstants.DATABASE_CREDITS)
    public Integer findRemaingForupdate(Long id) {
        return duibaHdtoolOptionsDao.findRemaingForupdate(id);
    }


    @Override
    public List<DuibaHdtoolOptionsDto> findOptionsByDuibaHdtoolId(final Long hdtoolId) {
        return cacheClient.getWithCacheLoader(getDuibaHdtoolOptionsCacheKeyByHdtoolId(hdtoolId), 30, TimeUnit.MINUTES, new CacheLoader<List<DuibaHdtoolOptionsDto>>() {
            @Override
            public List<DuibaHdtoolOptionsDto> load() {
                return BeanUtils.copyList(duibaHdtoolOptionsDao.findOptionsByDuibaHdtoolId(hdtoolId), DuibaHdtoolOptionsDto.class);
            }
        });
    }

    @Override
    public Map<Long, List<DuibaHdtoolOptionsDto>> findOptionsByDuibaHdtoolIds(List<Long> hdtoolIds){
        List<DuibaHdtoolOptionsEntity> list = duibaHdtoolOptionsDao.findOptionsByDuibaHdtoolIds(hdtoolIds);
        Map<Long, List<DuibaHdtoolOptionsDto>> map = new HashMap<>();
        for(DuibaHdtoolOptionsEntity e : list){
            List<DuibaHdtoolOptionsDto> innerList = map.get(e.getDuibaHdtoolId());
            if(innerList == null){
                innerList = new ArrayList<>();
                map.put(e.getDuibaHdtoolId(), innerList);
            }
            innerList.add(BeanUtils.copy(e, DuibaHdtoolOptionsDto.class));
        }

        return map;
    }

    @Override
    public Integer countOptionsByHdtoolId(Long hdtoolId) {
        return duibaHdtoolOptionsDao.countOptionsByHdtoolId(hdtoolId);
    }

    @Override
    public DuibaHdtoolOptionsDto findOptionById(final Long id) {
        return cacheClient.getWithCacheLoader(getDuibaHdtoolOptionsCacheKeyById(id), 30, TimeUnit.SECONDS, new CacheLoader<DuibaHdtoolOptionsDto>() {
            @Override
            public DuibaHdtoolOptionsDto load() {
                return BeanUtils.copy(duibaHdtoolOptionsDao.findOptionById(id), DuibaHdtoolOptionsDto.class);
            }
        });
    }

    @Override
    @Transactional(value= DsConstants.DATABASE_CREDITS)
    public DuibaHdtoolOptionsDto findOptionByIdForupdate(Long id) {
        return BeanUtils.copy(duibaHdtoolOptionsDao.findOptionByIdForupdate(id), DuibaHdtoolOptionsDto.class);
    }

    @Override
    public List<Long> findHasUserdHdIds(Long itemId) {
        return duibaHdtoolOptionsDao.findHasUserdHdIds(itemId);
    }

    @Override
    public int decrementOptionRemaining(Long id) {
        int ret = duibaHdtoolOptionsDao.decrementOptionRemaining(id);
        removeDuibaHdtoolOptionsCacheById(id);
        return ret;
    }

    @Override
    public int incrementOptionRemaining(Long id) {
        int ret = duibaHdtoolOptionsDao.incrementOptionRemaining(id);
        removeDuibaHdtoolOptionsCacheById(id);
        return ret;
    }

    @Override
    public int deleteOptions(List<Long> ids) {
        if(ids == null || ids.isEmpty()){
            return 0;
        }
        int ret = duibaHdtoolOptionsDao.deleteOptions(ids);
        for(Long id:ids) {
            removeDuibaHdtoolOptionsCacheById(id);
        }
        return ret;
    }

    @Override
    public int updateHdtoolPrize(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        int ret = duibaHdtoolOptionsDao.updateHdtoolPrize(BeanUtils.copy(duibaHdToolOptionDO, DuibaHdtoolOptionsEntity.class));
        removeDuibaHdtoolOptionsCacheById(duibaHdToolOptionDO.getId());
        return ret;
    }

    @Override
    public void insertHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        DuibaHdtoolOptionsEntity e = BeanUtils.copy(duibaHdToolOptionDO, DuibaHdtoolOptionsEntity.class);
        duibaHdtoolOptionsDao.insertHdtoolOption(e);
        cacheClient.remove(getDuibaHdtoolOptionsCacheKeyByHdtoolId(e.getDuibaHdtoolId()));
        duibaHdToolOptionDO.setId(e.getId());
    }

    @Override
    public int updateHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        int ret = duibaHdtoolOptionsDao.updateHdtoolOption(BeanUtils.copy(duibaHdToolOptionDO, DuibaHdtoolOptionsEntity.class));
        removeDuibaHdtoolOptionsCacheById(duibaHdToolOptionDO.getId());

        return ret;
    }

    private void removeDuibaHdtoolOptionsCacheById(Long optionsId){
        cacheClient.remove(getDuibaHdtoolOptionsCacheKeyById(optionsId));
        DuibaHdtoolOptionsDto dto = this.findOptionById(optionsId);
        if(dto != null){
            cacheClient.remove(getDuibaHdtoolOptionsCacheKeyByHdtoolId(dto.getDuibaHdtoolId()));
        }
    }
}
