package cn.com.duiba.activity.center.biz.service.manual.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.manual.ManualLotteryOrderDto;
import cn.com.duiba.activity.center.biz.dao.manuallottery.ManualOrderLotteryDao;
import cn.com.duiba.activity.center.biz.entity.manual.ManualLotteryOrderEntity;
import cn.com.duiba.activity.center.biz.service.manual.ManualOrderLotteryService;
import cn.com.duiba.activity.center.biz.support.copier.manual.ManualOrderLotteryCopier;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.google.common.base.Preconditions;

/**
 * Created by xuezhaoming on 16/6/7.
 */
@Service
public class ManualOrderLotteryServiceImpl implements ManualOrderLotteryService {

    @Resource
    private ManualOrderLotteryDao manualOrderLotteryDao;

    @Override
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {

        Preconditions.checkNotNull(consumerId);
        Preconditions.checkNotNull(operatingActivityId);

        return manualOrderLotteryDao.countByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId,
                                                                  Date start, Date end) {
        return manualOrderLotteryDao.countByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId,
                                                                                    start, end);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return manualOrderLotteryDao.countByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId,
                                                                      Date start, Date end) {
        return manualOrderLotteryDao.countFreeByConsumerIdAndOperatingActivityIdAndDate(consumerId,
                                                                                        operatingActivityId, start, end);
    }

    @Override
    public List<ManualLotteryOrderDto> findAllOpenManualLotteryByCondition(Map<String, Object> paramMap) {

        List<ManualLotteryOrderEntity> entities = manualOrderLotteryDao.findAllOpenManualLotteryByCondition(paramMap);
        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }

        List<ManualLotteryOrderDto> dtoList = ManualOrderLotteryCopier.entities2Dtos(entities);
        return dtoList;
    }

    @Override
    public Long findAllOpenManualLotteryCount(Map<String, Object> paramMap) {
        return manualOrderLotteryDao.findAllOpenManualLotteryCount(paramMap);
    }

    @Override
    public List<ManualLotteryOrderDto> findWardList(Long operatingActivityId) {
        List<ManualLotteryOrderEntity> wardList = manualOrderLotteryDao.findWardList(operatingActivityId);
        if (CollectionUtils.isEmpty(wardList)) {
            return Collections.emptyList();
        }

        return ManualOrderLotteryCopier.entities2Dtos(wardList);
    }

    @Override
    public List<ManualLotteryOrderDto> findNoWardList(Map<String, Object> paramMap) {
        List<ManualLotteryOrderEntity> noWardList = manualOrderLotteryDao.findNoWardList(paramMap);
        return ManualOrderLotteryCopier.entities2Dtos(noWardList);
    }

    @Override
    public Long findNoWardListCount(Map<String, Object> paramMap) {
        return manualOrderLotteryDao.findNoWardListCount(paramMap);
    }

    @Override
    public List<ManualLotteryOrderDto> findStartOpenListByIds(Map<String, Object> paramMap) {
        List<ManualLotteryOrderEntity> startOpenListByIds = manualOrderLotteryDao.findStartOpenListByIds(paramMap);
        return ManualOrderLotteryCopier.entities2Dtos(startOpenListByIds);
    }

    @Override
    public int updateAward(Long id, Long activityId, Date date) {
        return manualOrderLotteryDao.updateAward(id, activityId, date);
    }

    @Override
    public ManualLotteryOrderDto randomFindManualLottery(Map<String, Object> paramMap) {
        ManualLotteryOrderEntity entity = manualOrderLotteryDao.randomFindManualLottery(paramMap);
        return ManualOrderLotteryCopier.entity2Dto(entity);
    }

    @Override
    public void updateNoAwardList(Map<String, Object> paramMap) {

        manualOrderLotteryDao.updateNoAwardList(paramMap);
    }

    @Override
    public List<ManualLotteryOrderDto> findAllNoAwardList(Map<String, Object> paramMap) {
        List<ManualLotteryOrderEntity> allNoAwardList = manualOrderLotteryDao.findAllNoAwardList(paramMap);
        return ManualOrderLotteryCopier.entities2Dtos(allNoAwardList);
    }

    @Override
    public List<ManualLotteryOrderDto> findAllByIds(List<Long> ids) {
        List<ManualLotteryOrderEntity> allByIds = manualOrderLotteryDao.findAllByIds(ids);
        return ManualOrderLotteryCopier.entities2Dtos(allByIds);
    }

    @Override
    public ManualLotteryOrderDto findByOrderId(Long orderId) {
        ManualLotteryOrderEntity byOrderId = manualOrderLotteryDao.findByOrderId(orderId);
        return ManualOrderLotteryCopier.entity2Dto(byOrderId);
    }

    @Override
    public ManualLotteryOrderDto findByAppAndDeveloperBizId(Long appId, String bizId) {
        ManualLotteryOrderEntity orderEntity = manualOrderLotteryDao.findByAppAndDeveloperBizId(appId, bizId);
        return ManualOrderLotteryCopier.entity2Dto(orderEntity);
    }

    @Override
    public void insert(ManualLotteryOrderDto orderDTO) {
    	ManualLotteryOrderEntity entity = BeanUtils.copy(orderDTO, ManualLotteryOrderEntity.class);
        manualOrderLotteryDao.insert(entity);
        orderDTO.setId(entity.getId());
    }

    @Override
    public void update(ManualLotteryOrderDto orderDTO) {
        ManualLotteryOrderEntity entity = ManualOrderLotteryCopier.dto2entity(orderDTO);
        manualOrderLotteryDao.update(entity);
    }

    @Override
    public ManualLotteryOrderDto find(Long id) {
        ManualLotteryOrderEntity entity = manualOrderLotteryDao.find(id);
        return ManualOrderLotteryCopier.entity2Dto(entity);
    }
}
