package cn.com.duiba.activity.center.biz.service.ngame.impl;

import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameBrickDto;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameBrickDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameBrickEntity;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameBrickService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Created by wenqi.huang on 16/6/15.
 */
@Service
public class DuibaNgameBrickServiceImpl implements DuibaNgameBrickService {
    @Resource
    private DuibaNgameBrickDao duibaNgameBrickDao;
    @Resource
    private CacheClient cacheClient;

    @Override
    public DuibaNgameBrickDto find(Long id) {
        return BeanUtils.copy(duibaNgameBrickDao.find(id), DuibaNgameBrickDto.class);
    }

    @Override
    public void insert(DuibaNgameBrickDto duibaNgameBrickDto) {
        DuibaNgameBrickEntity e = BeanUtils.copy(duibaNgameBrickDto, DuibaNgameBrickEntity.class);
        duibaNgameBrickDao.insert(e);
        duibaNgameBrickDto.setId(e.getId());
    }

    @Override
    public void update4Admin(DuibaNgameBrickDto duibaNgameBrickDto) {
        duibaNgameBrickDao.update4Admin(BeanUtils.copy(duibaNgameBrickDto, DuibaNgameBrickEntity.class));
        cacheClient.remove(getNoContentCacheKeyById(duibaNgameBrickDto.getId()));
        cacheClient.remove(getContentCacheKeyById(duibaNgameBrickDto.getId()));
    }

    @Override
    public DuibaNgameBrickDto findByTitle(String title) {
        return BeanUtils.copy(duibaNgameBrickDao.findByTitle(title), DuibaNgameBrickDto.class);
    }

    @Override
    public void open(Long id) {
        duibaNgameBrickDao.open(id);
        cacheClient.remove(getNoContentCacheKeyById(id));
    }

    @Override
    public void disable(Long id) {
        duibaNgameBrickDao.disable(id);
        cacheClient.remove(getNoContentCacheKeyById(id));
    }

    @Override
    public List<DuibaNgameBrickDto> findPage(Integer offset, Integer max) {
        return BeanUtils.copyList(duibaNgameBrickDao.findPage(offset, max), DuibaNgameBrickDto.class);
    }

    @Override
    public Long findPageCount() {
        return duibaNgameBrickDao.findPageCount();
    }

    @Override
    public List<DuibaNgameBrickDto> findAll() {
        return BeanUtils.copyList(duibaNgameBrickDao.findAll(), DuibaNgameBrickDto.class);
    }

    @Override
    public String getBrickContentById(final Long id) {
        return cacheClient.getWithCacheLoader(getContentCacheKeyById(id), 1, TimeUnit.HOURS, new CacheLoader<String>() {
            @Override
            public String load() {
                return duibaNgameBrickDao.getBrickContentById(id);
            }
        });
    }

    private String getNoContentCacheKeyById(Long id){
        return CacheConstants.KEY_DUIBA_NGAMR_BRICK_NO_CONTENT_BY_ID + id;
    }

    private String getContentCacheKeyById(Long id){
        return CacheConstants.KEY_DUIBA_NGAMR_BRICK_CONTENT_BY_ID + id;
    }

    @Override
    public DuibaNgameBrickDto findNoContent(final Long id) {
        return cacheClient.getWithCacheLoader(getNoContentCacheKeyById(id), 20, TimeUnit.MINUTES, new CacheLoader<DuibaNgameBrickDto>() {
            @Override
            public DuibaNgameBrickDto load() {
                return BeanUtils.copy(duibaNgameBrickDao.findNoContent(id), DuibaNgameBrickDto.class);
            }
        });
    }
}
