package cn.com.duiba.activity.center.biz.service.quizz.impl;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzOptionsDto;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzOptionsDao;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzOptionsEntity;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzOptionsService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * Created by xuezhaoming on 16/6/7.
 */
@Service
public class DuibaQuizzOptionsServiceImpl implements DuibaQuizzOptionsService {

    @Resource
    private DuibaQuizzOptionsDao duibaQuizzOptionsDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id){
        return CacheConstants.KEY_DUIBA_QUIZZ_OPTIONS_BY_ID + id;
    }
    private String getCacheKeyByQuizzId(Long quizzId){
        return CacheConstants.KEY_DUIBA_QUIZZ_OPTIONS_BY_QUIZZ_ID + quizzId;
    }

    @Override
    public List<DuibaQuizzOptionsDto> findOptionsByQuizzId(final Long duibaQuizzId) {
        if (duibaQuizzId == null) {
            return Collections.emptyList();
        }

        return cacheClient.getWithCacheLoader(getCacheKeyByQuizzId(duibaQuizzId), 1, TimeUnit.HOURS, new CacheLoader<List<DuibaQuizzOptionsDto>>() {
            @Override
            public List<DuibaQuizzOptionsDto> load() {
                List<DuibaQuizzOptionsEntity> entities = duibaQuizzOptionsDao.findOptionsByQuizzId(duibaQuizzId);
                return BeanUtils.copyList(entities, DuibaQuizzOptionsDto.class);
            }
        });
    }

    @Override
    public DuibaQuizzOptionsDto find(final Long id) {
        if (id == null) {
            return null;
        }

        return cacheClient.getWithCacheLoader(getCacheKeyById(id), 1, TimeUnit.HOURS, new CacheLoader<DuibaQuizzOptionsDto>() {
            @Override
            public DuibaQuizzOptionsDto load() {
                DuibaQuizzOptionsEntity entity = duibaQuizzOptionsDao.find(id);
                return BeanUtils.copy(entity, DuibaQuizzOptionsDto.class);
            }
        });
    }

    public Map<Long, List<DuibaQuizzOptionsDto>> findByQuizzIds(List<Long> quizzIds){
        List<DuibaQuizzOptionsEntity> list = duibaQuizzOptionsDao.findOptionsByQuizzIds(quizzIds);
        Map<Long, List<DuibaQuizzOptionsDto>> map = new HashMap<>();
        for(DuibaQuizzOptionsEntity e : list){
            List<DuibaQuizzOptionsDto> innerList = map.get(e.getDuibaQuizzId());
            if(innerList == null){
                innerList = new ArrayList<>();
                map.put(e.getDuibaQuizzId(), innerList);
            }
            innerList.add(BeanUtils.copy(e, DuibaQuizzOptionsDto.class));
        }
        return map;
    }

    @Override
    public int delete(List<Long> ids) {
        if(ids == null || ids.isEmpty()){
            return 0;
        }
        Set<Long> quizzIds = new HashSet<>();
        for(Long id : ids) {
            DuibaQuizzOptionsDto dto = this.find(id);
            if(dto != null) {
                quizzIds.add(dto.getDuibaQuizzId());
            }
        }
        int ret = duibaQuizzOptionsDao.delete(ids);
        for(Long id : ids) {
            cacheClient.remove(getCacheKeyById(id));
        }
        for(Long quizzId : quizzIds) {
            cacheClient.remove(getCacheKeyByQuizzId(quizzId));
        }
        return ret;
    }

    @Override
    public void insert(DuibaQuizzOptionsDto duibaQuizzOptionsDto) {
    	DuibaQuizzOptionsEntity entity = BeanUtils.copy(duibaQuizzOptionsDto, DuibaQuizzOptionsEntity.class);
        duibaQuizzOptionsDao.insert(entity);
        duibaQuizzOptionsDto.setId(entity.getId());
        cacheClient.remove(getCacheKeyByQuizzId(duibaQuizzOptionsDto.getDuibaQuizzId()));
    }

    @Override
    public int updateInfoForm(DuibaQuizzOptionsDto quizzOptionsDO) {
        int ret = duibaQuizzOptionsDao.updateInfoForm(BeanUtils.copy(quizzOptionsDO, DuibaQuizzOptionsEntity.class));
        cacheClient.remove(getCacheKeyById(quizzOptionsDO.getId()));

        quizzOptionsDO = this.find(quizzOptionsDO.getId());

        cacheClient.remove(getCacheKeyByQuizzId(quizzOptionsDO.getDuibaQuizzId()));
        return ret;
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        int ret = duibaQuizzOptionsDao.updateRemainingById(id, remaining);
        cacheClient.remove(getCacheKeyById(id));
        DuibaQuizzOptionsDto dto = this.find(id);
        cacheClient.remove(getCacheKeyByQuizzId(dto.getDuibaQuizzId()));
        return ret;
    }

}
