package cn.com.duiba.activity.center.biz.service.quizz.impl;

import javax.annotation.Resource;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.QuizzStockConsumeDto;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzStockConsumeDao;
import cn.com.duiba.activity.center.biz.entity.quizz.QuizzStockConsumeEntity;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzStockConsumeService;
import cn.com.duiba.activity.center.biz.support.copier.quizz.QuizzStockConsumeCopier;

/**
 * Created by xuezhaoming on 16/6/7.
 */
@Service
public class DuibaQuizzStockConsumeServiceImpl implements DuibaQuizzStockConsumeService {

    @Resource
    private DuibaQuizzStockConsumeDao duibaQuizzStockConsumeDao;

    @Override
    public void insert(QuizzStockConsumeDto quizzStockConsumeDto) {
        if (quizzStockConsumeDto == null) {
            return;
        }

        QuizzStockConsumeEntity entity = QuizzStockConsumeCopier.dto2entity(quizzStockConsumeDto);
        duibaQuizzStockConsumeDao.insert(entity);
        quizzStockConsumeDto.setId(entity.getId());
    }

    @Override
    public QuizzStockConsumeDto findByBizId(Long quizzOrderId, String action) {
        if (quizzOrderId == null || StringUtils.isBlank(action)) {
            return null;
        }

        QuizzStockConsumeEntity entity = duibaQuizzStockConsumeDao.findByBizId(quizzOrderId, action);
        return QuizzStockConsumeCopier.entity2Dto(entity);
    }
}
