package cn.com.duiba.activity.center.biz.service.quizz.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.QuizzOrdersDto;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrderTextChangeDao;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrdersSequenceDao;
import cn.com.duiba.activity.center.biz.entity.quizz.QuizzOrdersEntity;
import cn.com.duiba.activity.center.biz.kafka.QuizzMQSend;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzOrderTextChangeService;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.google.common.base.Preconditions;

/**
 * Created by xuezhaoming on 16/6/8.<br/>
 * <br/>
 * <br/>
 * <br/>
 */
@Service
public class QuizzOrderTextChangeServiceImpl implements QuizzOrderTextChangeService {

    // private static final Logger LOG = LoggerFactory.getLogger(QuizzOrderTextChangeServiceImpl.class);

    @Autowired
    private QuizzOrdersSequenceDao quizzOrdersSequenceDao;

    @Autowired
    private QuizzMQSend             quizzMQSend;

    @Autowired
    private QuizzOrderTextChangeDao quizzOrderTextChangeDao;

    @Override
    public void insert(QuizzOrdersDto quizzOrdersDto) {

        Preconditions.checkNotNull(quizzOrdersDto, "quizzOrdersEntity is null ");

        Long id = quizzOrdersSequenceDao.getId();

        int ret = quizzOrderTextChangeDao.insert(BeanUtils.copy(quizzOrdersDto, QuizzOrdersEntity.class), id);
        
        quizzOrdersDto.setId(id);

        if (ret == 1) {
            quizzMQSend.quizzSendDataSync(quizzOrdersDto.getConsumerId(), quizzOrdersDto.getId());
        }
    }

    @Override
    public int updateDeveloperBizId(Long consumerId, long id, String bizId) {

        Preconditions.checkNotNull(consumerId, "consumerId is null ");
        Preconditions.checkNotNull(id, "id is null ");
        Preconditions.checkNotNull(bizId, "bizId is null ");

        int ret = quizzOrderTextChangeDao.updateDeveloperBizId(consumerId, id, bizId);
        if (ret == 1) {
            quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;

    }

    @Override
    public int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum) {

        Preconditions.checkNotNull(consumerId, "bizId is null ");
        Preconditions.checkNotNull(id, "id is null ");
        Preconditions.checkNotNull(mainOrderId, "mainOrderId is null ");
        Preconditions.checkNotNull(mainOrderNum, "mainOrderNum is null ");

        int ret = quizzOrderTextChangeDao.updateMainOrderId(consumerId, id, mainOrderId, mainOrderNum);
        if (ret == 1) {
            quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;
    }
    
    @Override
    public QuizzOrdersDto find(Long consumerId, Long id){
    	QuizzOrdersEntity entity = quizzOrderTextChangeDao.find(consumerId, id);
    	return BeanUtils.copy(entity, QuizzOrdersDto.class);
    }
}
