package cn.com.duiba.activity.center.biz.service.seconds_kill.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.seconds_kill.DuibaSecondsKillActivityBrickDto;
import cn.com.duiba.activity.center.biz.dao.seconds_kill.DuibaSecondsKillActivityBrickDao;
import cn.com.duiba.activity.center.biz.entity.seconds_kill.DuibaSecondsKillActivityBrickEntity;
import cn.com.duiba.activity.center.biz.service.seconds_kill.DuibaSecondsKillActivityBrickService;
import cn.com.duiba.wolf.utils.BeanUtils;

@Service
public class DuibaSecondsKillActivityBrickServiceImpl implements
		DuibaSecondsKillActivityBrickService {
	
	@Autowired
	private DuibaSecondsKillActivityBrickDao duibaSecondsKillActivityBrickDao;
	@Autowired
	private CacheClient cacheClient;

	private String getCacheKeyById(Long id){
		return CacheConstants.KEY_DUIBA_SECKILL_ACT_BRICK_BY_ID + id;
	}

	@Override
	public List<DuibaSecondsKillActivityBrickDto> findPage(Map<String, Object> paramMap) {
		return BeanUtils.copyList(duibaSecondsKillActivityBrickDao.findPage(paramMap), DuibaSecondsKillActivityBrickDto.class);
	}

	@Override
	public Long findPageCount() {
		return duibaSecondsKillActivityBrickDao.findPageCount();
	}

	@Override
	public DuibaSecondsKillActivityBrickDto find(final Long id) {
		return cacheClient.getWithCacheLoader(getCacheKeyById(id), 1, TimeUnit.HOURS, new CacheLoader<DuibaSecondsKillActivityBrickDto>() {
			@Override
			public DuibaSecondsKillActivityBrickDto load() {
				return BeanUtils.copy(duibaSecondsKillActivityBrickDao.find(id), DuibaSecondsKillActivityBrickDto.class);
			}
		});
	}

	@Override
	public void insert(DuibaSecondsKillActivityBrickDto duibaSecondsKillActivityBrick) {
		DuibaSecondsKillActivityBrickEntity entity = BeanUtils.copy(duibaSecondsKillActivityBrick, DuibaSecondsKillActivityBrickEntity.class);
		duibaSecondsKillActivityBrickDao.insert(entity);
		duibaSecondsKillActivityBrick.setId(entity.getId());
	}

	@Override
	public void update(DuibaSecondsKillActivityBrickDto duibaSecondsKillActivityBrick) {
		duibaSecondsKillActivityBrickDao.update(BeanUtils.copy(duibaSecondsKillActivityBrick, DuibaSecondsKillActivityBrickEntity.class));
		cacheClient.remove(getCacheKeyById(duibaSecondsKillActivityBrick.getId()));
	}

	@Override
	public void open(Long id) {
		duibaSecondsKillActivityBrickDao.open(id);
		cacheClient.remove(getCacheKeyById(id));
	}

	@Override
	public void disable(Long id) {
		duibaSecondsKillActivityBrickDao.disable(id);
		cacheClient.remove(getCacheKeyById(id));
	}

	@Override
	public DuibaSecondsKillActivityBrickDto findByTitle(String title) {
		return BeanUtils.copy(duibaSecondsKillActivityBrickDao.findByTitle(title), DuibaSecondsKillActivityBrickDto.class);
	}

	@Override
	public List<DuibaSecondsKillActivityBrickDto> findAllEnable() {
		return BeanUtils.copyList(duibaSecondsKillActivityBrickDao.findAllEnable(), DuibaSecondsKillActivityBrickDto.class);
	}

}
