package cn.com.duiba.activity.center.biz.service.singlelottery.impl;

import cn.com.duiba.activity.center.api.dto.singlelottery.AppSingleLotteryDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.singlelottery.SingleLotteryDao;
import cn.com.duiba.activity.center.biz.entity.singlelottery.AppSingleLotteryEntity;
import cn.com.duiba.activity.center.biz.service.singlelottery.SingleLotteryService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by yansen on 16/6/20.
 */
@Service
public class SingleLotteryServiceImpl implements SingleLotteryService{
    @Resource
    private SingleLotteryDao singleLotteryDao;

    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return CacheConstants.KEY_SINGLE_LOTTERY_BY_ID + id;
    }

    @Override
    public AppSingleLotteryDto find(Long id) {
        String key = getCacheKeyById(id);
        AppSingleLotteryDto d=cacheClient.get(key);
        if(d==null){
            AppSingleLotteryEntity entity=singleLotteryDao.find(id);
            if (entity == null) {
                return null;
            }
            d = BeanUtils.copy(entity,AppSingleLotteryDto.class);
            cacheClient.set(key,d,300);
        }
        return BeanUtils.copy(singleLotteryDao.find(id),AppSingleLotteryDto.class);
    }

    @Override
    @Transactional(value= DsConstants.DATABASE_CREDITS)
    public AppSingleLotteryDto findForupdate(Long id) {
        return BeanUtils.copy(singleLotteryDao.findForupdate(id),AppSingleLotteryDto.class);
    }

    @Override
    public List<AppSingleLotteryDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(singleLotteryDao.findAllByIds(ids),AppSingleLotteryDto.class);
    }

    @Override
    public int addMainAppItemRemainingById(Long id, Integer addMainAppItemRemaining) {
        int result= singleLotteryDao.addMainAppItemRemainingById(id, addMainAppItemRemaining);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public int subMainAppItemRemainingById(Long id, Integer subMainAppItemRemaining) {
        int result= singleLotteryDao.subMainAppItemRemainingById(id, subMainAppItemRemaining);
        cacheClient.remove(getCacheKeyById(id));
        return  result;
    }

    @Override
    @Transactional(value= DsConstants.DATABASE_CREDITS)
    public Integer findRemaingForupdate(Long id) {
        return singleLotteryDao.findRemaingForupdate(id);
    }

    @Override
    public void insert(AppSingleLotteryDto appSingleLotteryDto) {
        AppSingleLotteryEntity entity=new AppSingleLotteryEntity(true);
        BeanUtils.copy(appSingleLotteryDto,entity);
        singleLotteryDao.insert(entity);
        appSingleLotteryDto.setId(entity.getId());
    }

    @Override
    public int update(AppSingleLotteryDto appSingleLotteryDto) {
        int result= singleLotteryDao.update(BeanUtils.copy(appSingleLotteryDto,AppSingleLotteryEntity.class));
        cacheClient.remove(getCacheKeyById(appSingleLotteryDto.getId()));
        return result;
    }

    @Override
    public int reduceMainAppItemRemaining(Long id) {
        int result= singleLotteryDao.reduceMainAppItemRemaining(id);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public int addMainAppItemRemaining(Long id) {
        int result= singleLotteryDao.addMainAppItemRemaining(id);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public int updateForDevEdit(AppSingleLotteryDto appSingleLottery) {
        int result=  singleLotteryDao.updateForDevEdit(BeanUtils.copy(appSingleLottery,AppSingleLotteryEntity.class));
        cacheClient.remove(getCacheKeyById(appSingleLottery.getId()));
        return result;
    }
}
