package cn.com.duiba.activity.center.biz.support.copier.quizz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.sf.cglib.beans.BeanCopier;

import org.apache.commons.collections4.CollectionUtils;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzStockDto;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzStockEntity;

/**
 * Created by xuezhaoming on 16/6/7.
 */
public final class DuibaQuizzStockCopier {

    public static final BeanCopier Entity2DTO = BeanCopier.create(DuibaQuizzStockEntity.class,
                                                                  DuibaQuizzStockDto.class, false);

    public static final BeanCopier DTO2Entity = BeanCopier.create(DuibaQuizzStockDto.class,
                                                                  DuibaQuizzStockEntity.class, false);

    public static DuibaQuizzStockDto entity2Dto(DuibaQuizzStockEntity entity) {

        if (entity == null) {
            return null;
        }

        DuibaQuizzStockDto quizzOptionsDTO = new DuibaQuizzStockDto();
        Entity2DTO.copy(entity, quizzOptionsDTO, null);

        return quizzOptionsDTO;
    }

    public static DuibaQuizzStockEntity dto2entity(DuibaQuizzStockDto dto) {

        if (dto == null) {
            return null;
        }

        DuibaQuizzStockEntity entity = new DuibaQuizzStockEntity();
        DTO2Entity.copy(dto, entity, null);

        return entity;
    }

    public static List<DuibaQuizzStockDto> entities2Dtos(List<DuibaQuizzStockEntity> entities) {

        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }

        List<DuibaQuizzStockDto> dtoList = new ArrayList<>(entities.size());
        for (DuibaQuizzStockEntity entity : entities) {
            DuibaQuizzStockDto optionsDTO = entity2Dto(entity);
            dtoList.add(optionsDTO);
        }
        return dtoList;
    }
}
