package cn.com.duiba.activity.center.biz.support.copier.quizz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.sf.cglib.beans.BeanCopier;

import org.apache.commons.collections4.CollectionUtils;

import cn.com.duiba.activity.center.api.dto.quizz.QuizzStockConsumeDto;
import cn.com.duiba.activity.center.biz.entity.quizz.QuizzStockConsumeEntity;

/**
 * Created by xuezhaoming on 16/6/7.
 */
public final class QuizzStockConsumeCopier {

    public static final BeanCopier Entity2DTO = BeanCopier.create(QuizzStockConsumeEntity.class,
                                                                  QuizzStockConsumeDto.class, false);

    public static final BeanCopier DTO2Entity = BeanCopier.create(QuizzStockConsumeDto.class,
                                                                  QuizzStockConsumeEntity.class, false);

    public static QuizzStockConsumeDto entity2Dto(QuizzStockConsumeEntity entity) {

        if (entity == null) {
            return null;
        }

        QuizzStockConsumeDto quizzOptionsDTO = new QuizzStockConsumeDto();
        Entity2DTO.copy(entity, quizzOptionsDTO, null);

        return quizzOptionsDTO;
    }

    public static QuizzStockConsumeEntity dto2entity(QuizzStockConsumeDto dto) {

        if (dto == null) {
            return null;
        }

        QuizzStockConsumeEntity entity = new QuizzStockConsumeEntity();
        DTO2Entity.copy(dto, entity, null);

        return entity;
    }

    public static List<QuizzStockConsumeDto> entities2Dtos(List<QuizzStockConsumeEntity> entities) {

        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }

        List<QuizzStockConsumeDto> dtoList = new ArrayList<>(entities.size());
        for (QuizzStockConsumeEntity entity : entities) {
            QuizzStockConsumeDto optionsDTO = entity2Dto(entity);
            dtoList.add(optionsDTO);
        }
        return dtoList;
    }
}
