package cn.com.duiba.activity.center.biz.tools.service;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;

@Service
public class TimeLimitService {

	// 限时，限量，会员等级限制，兑换限制，日期限制等有限制的，都不中奖
	public boolean isLimitItemKey(ItemKey itemKey) {
		if (itemKey.getAppItem() != null) {
			if (itemKey.getAppItem().isOpTypeAppItem(ItemDO.OpTypeTimeLimit)) {
				return true;
			}
			if (itemKey.getAppItem().isOpTypeAppItem(ItemDO.OpTypeQuantityLimit)) {
				return true;
			}
			// 支付宝,QB,话费 忽略会员等级
			if(!ItemDO.TypeAlipay.equals(itemKey.getItemType()) && !ItemDO.TypeQB.equals(itemKey.getItemType()) && !ItemDO.TypePhonebill.equals(itemKey.getItemType())){
				if (itemKey.getAppItem().getVipLimitType() != null && itemKey.getAppItem().getVipLimitType() != AppItemDO.OFF_LEVEL) {
					return true;
				}
			}
			if (itemKey.getAppItem().getLimitCount() != null && itemKey.getAppItem().getLimitCount() > 0) {
				return true;
			}
			if (itemKey.getAppItem().getLimitDate() != null && !itemKey.getAppItem().getLimitDate().equals("no")) {
				return true;
			}
			if (StringUtils.isNotBlank(itemKey.getAppItem().getLimitTimeBetween())){
				return true;
			}
		}
		if (itemKey.getItem() != null) {
			if (itemKey.getItem().isOpTypeItem(ItemDO.OpTypeTimeLimit)) {
				return true;
			}
			if (itemKey.getItem().isOpTypeItem(ItemDO.OpTypeQuantityLimit)) {
				return true;
			}
			if (itemKey.getItem().getLimitCount() != null && itemKey.getItem().getLimitCount() > 0) {
				return true;
			}
			if (itemKey.getItem().getLimitDate() != null && !itemKey.getItem().getLimitDate().equals("no")) {
				return true;
			}
			if (StringUtils.isNotBlank(itemKey.getItem().getLimitTimeBetween())){
				return true;
			}
		}
		return false;
	}

	public boolean isLimitItem(ItemDO item){
		if (item.isOpTypeItem(ItemDO.OpTypeTimeLimit)) {
			return true;
		}
		if (item.isOpTypeItem(ItemDO.OpTypeQuantityLimit)) {
			return true;
		}
		if (item.getLimitCount() != null && item.getLimitCount() > 0) {
			return true;
		}
		if (item.getLimitDate() != null && !item.getLimitDate().equals("no")) {
			return true;
		}
		if (StringUtils.isNotBlank(item.getLimitTimeBetween())){
			return true;
		}
		return false;
	}
}
