/**
 * Project Name:activity-center-biz
 * File Name:ActivityBoImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.bo.activity.impl
 * Date:2016年7月26日下午7:59:46
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.bo.activity.impl;
import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;
import cn.com.duiba.activity.center.api.dto.direct.ActivityBlackList4DeveloperDto;
import cn.com.duiba.activity.center.api.dto.direct.DuibaActivityAppSpecifyNewDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.api.remoteservice.direct.RemoteActivityBlackList4DeveloperService;
import cn.com.duiba.activity.center.api.remoteservice.direct.RemoteDuibaActivityAppSpecifyNewService;
import cn.com.duiba.activity.center.biz.bo.activity.ActivityBo;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCreditsService;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent.ActivityOrdersEventType;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.activity.center.biz.service.direct.DuibaActivityAppSpecifyNewService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobConfigService;
import cn.com.duiba.activity.center.biz.tools.RedisClientTool;
import cn.com.duiba.activity.center.biz.tools.service.FrequentExchangeLimitService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * ClassName:ActivityBoImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月26日 下午7:59:46 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class ActivityBoImpl implements ActivityBo{
    
    private static Logger log = LoggerFactory.getLogger(ActivityBoImpl.class);
    @Autowired
    private FrequentExchangeLimitService frequentExchangeLimit;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private RemoteActivityBlackList4DeveloperService remoteActivityBlackList4DeveloperService;
    @Autowired
    private RemoteDuibaActivityAppSpecifyNewService remoteDuibaActivityAppSpecifyNewService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private TodayRobConfigService todayRobConfigService;
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private ConsumerCreditsService consumerCreditsService;
    @Autowired
    private RedisClientTool  redisClientTool;
    @Autowired
    private ActPreStockSerivce actPreStockSerivce;
    @Autowired
    private DuibaActivityAppSpecifyNewService duibaActivityAppSpecifyNewService;
    
    @Override
    public String cutPrice(Long TodayShoppingId, String activityType, Long consumerId, String ip, String ua,String transfer) throws Exception{
        log.error("->>进入砍价configId:" + TodayShoppingId + ";type:" + activityType + ";consumerId=" + consumerId + ";ip=" + ip);
        TodayRobConfigDto todayRobConfigDto = todayRobConfigService.find(TodayShoppingId);
        ConsumerDO consumer = remoteConsumerService.find(consumerId);
        AppDO appDO = remoteAppService.find(consumer.getAppId());
        Integer credits = todayRobConfigDto.getCredits();
        //预分配积分
        String activityId = "-" + TodayShoppingId;
        ActPreStockDto creditsStock = actPreStockSerivce.findPreStockByApp(Long.valueOf(activityId), "Credits", consumer.getAppId());
        if(null != creditsStock){
            credits = creditsStock.getPrizeQuantity().intValue();
        }
        credits = (int)Math.ceil(credits * appDO.getCreditsRate() / 100.0);
        if (credits>0 && credits < 1) {
            credits = 1;
        }
        //用户下单及活动权限验证
        checkPermission(consumer, todayRobConfigDto,credits);
        //产生订单号
        String orderNum = createOrder(consumer, todayRobConfigDto, ip,credits);
        //扣除本地积分
        if(credits > 0){
            remoteConsumerService.decrementCredits(consumerId,(long)credits);
        }
        ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(orderNum).getResult();
        //用于统计
        DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEventType.OnOrderCreate, order));
        //扣积分操作   
        // update  chengdeman  2016-09-18  抽象描述，增加减积分的公用性
        String description = "今日必抢："+todayRobConfigDto.getTitle();
        consumerCreditsService.asyncConsumerCredits(consumerId, orderNum, transfer,ip,description);
        return orderNum;
    }
    
    @Override
    public void checkPermission(ConsumerDO consumer, TodayRobConfigDto todayRobConfigDto,Integer credits) throws Exception {
        if(null == consumer || null == todayRobConfigDto){
            throw new StatusException(0, "无访问权限");
        }
        //未登陆
        if(ConsumerDO.NotLoginUserId.equals(consumer.getPartnerUserId())){
            throw new StatusException(0, "请先登录");
        }
        //预览用户
        if(ConsumerDO.PreviewUserId.equals(consumer.getPartnerUserId())){
            throw new StatusException(0,"预览用户");
        }
        //积分不足
        if(credits > consumer.getCredits()){
            throw new StatusException(0,"积分不足");
        }
        //活动状态验证
        if(todayRobConfigDto.getDeleted() || todayRobConfigDto.getStatus() != TodayRobConfigDto.STATUS_STARTUP){
            throw new StatusException(0, "活动已结束");
        }
        //用户在1秒内频繁下单限制
        if (!frequentExchangeLimit.canPass(consumer.getId(), 1)) {
            throw new StatusException(StatusException.CodeFrequentExchange);
        }
        AppDO app = remoteAppService.find(consumer.getAppId());
        //黑名单限制
        if(todayRobConfigDto.isOpenSwitch(TodayRobConfigDto.SWITCHES_DEV_BLACKLIST)){
            if(remoteActivityBlackList4DeveloperService
                    .isExistBlackByActivityIdAndActivityTypeAndDeveloperId(todayRobConfigDto.getId(),
                                                                           ActivityBlackList4DeveloperDto.TypeDuibaRob,app.getDeveloperId()).getResult()){
                throw new StatusException(0, "黑名单中无法参与");
            }
        }
        //定向App验证
        if(todayRobConfigDto.isOpenSwitch(TodayRobConfigDto.SWITCHES_DIRECT)){
            DuibaActivityAppSpecifyNewDto dto = duibaActivityAppSpecifyNewService.
                    findAppSpecifyByActivityIdAndAppIdAndActivityType(todayRobConfigDto.getId(),consumer.getAppId(), DuibaActivityAppSpecifyNewDto.ACTIVITY_HD_TYPE_ROB);
            if(null == dto){
                throw new StatusException(0, "定向商品无法参法");
            }
        }
        String orderNum = redisClientTool.getOrderNum(consumer.getId(), todayRobConfigDto.getId(), ActivityOrderDto.TypeRob);
        if(StringUtils.isNotBlank(orderNum)){
            throw new StatusException(0, "用户永久限制抢一次");
        }
        //用户抢购限制
        DubboResult<Integer> num = remoteActivityOrderService.findConsumerDuibaActivityNum(consumer.getId(),todayRobConfigDto.getId(),ActivityOrderDto.TypeRob);
        if(num.isSuccess() && num.getResult() != null && num.getResult() >= 1){
            throw new StatusException(0, "用户永久限制抢一次");
        }
        //APP交易数限制
        if (!app.isAppSwitch(AppDO.SwitchCloseAppTradingLimit)){
            Integer tradingCount = frequentExchangeLimit.getTodayTradingCount(app.getId());
            if (tradingCount >= 50) {
                throw new StatusException(StatusException.CodeAppTradingLimit);
            }
        }
        
    }

    @Override
    public String createOrder(ConsumerDO consumer, TodayRobConfigDto todayRobConfigDto,String ip,Integer credits) throws Exception{
        ActivityOrderDto orderDto = new ActivityOrderDto();
        orderDto.setConsumerId(consumer.getId());
        orderDto.setAppId(consumer.getAppId());
        orderDto.setPartnerUserId(consumer.getPartnerUserId());
        orderDto.setDuibaActivityId(todayRobConfigDto.getId());
        orderDto.setActivityType(ActivityOrderDto.TypeRob);
        orderDto.setConsumeCredits((long)credits);
        orderDto.setExchangeStatus(ActivityOrderDto.ExchangeWait);
        orderDto.setConsumeCreditsStatus(ActivityOrderDto.ConsumeCreditsProcessing);
        orderDto.setIp(ip);
        Date now = new Date();
        orderDto.setGmtCreate(now);
        orderDto.setGmtModified(now);
        String orderNum = null;
        try{
            orderNum = remoteActivityOrderService.createOrder(orderDto).getResult();
        }catch(Exception e){
            log.error("创建订单失败",e);
            throw e;
        }
        return orderNum;
    }
    
}

