package cn.com.duiba.activity.center.biz.dao.game.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionStockConsumeDao;
import cn.com.duiba.activity.center.biz.entity.game.QuestionStockConsumeEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

@Repository
public class DuibaQuestionStockConsumeDaoImpl extends ActivityBaseDao implements DuibaQuestionStockConsumeDao {

	@Override
	public void insert(QuestionStockConsumeEntity questionStockConsumerDO) {
		insert("insert", questionStockConsumerDO);
	}

	@Override
	public QuestionStockConsumeEntity findByBizId(String bizId, String action) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("bizId", bizId);
		paramMap.put("action", action);
		return selectOne("findByBizId", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_GAME;
	}
}
