package cn.com.duiba.activity.center.biz.dao.guess.impl;


import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.guess.DuibaGuessOptionsDao;
import cn.com.duiba.activity.center.biz.entity.guess.DuibaGuessOptionsEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository("duibaGuessOptionsDAO")
public class DuibaGuessOptionsDaoImpl extends ActivityBaseDao implements DuibaGuessOptionsDao {
	@Override
	public List<DuibaGuessOptionsEntity> findByGuessId(Long guessId) {
		return selectList("findByGuessId", guessId);
	}
	
	@Override
	public DuibaGuessOptionsEntity findById(Long id) {
		return selectOne("findById", id);
	}

	@Override
	public List<DuibaGuessOptionsEntity> findByAutoOpen(Long guessId,boolean autoOpen) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("guessId", guessId);
		paramMap.put("autoOpen", autoOpen);
		return selectList("findByAutoOpen", paramMap);
	}

	@Override
	public List<DuibaGuessOptionsEntity> findByAutoOpenAsc(Long guessId,boolean autoOpen) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("guessId", guessId);
		paramMap.put("autoOpen", autoOpen);
		return selectList("findByAutoOpenAsc", paramMap);
	}

	@Override
	public int delete(List<Long> ids) {
		Map<String, Object> params=new HashMap<String, Object>();
		params.put("ids", ids);
		return update("delete", params);
	}

	@Override
	public void insert(DuibaGuessOptionsEntity guessOptionsEntity) {
		insert("insert", guessOptionsEntity);
	}

	@Override
	public int updateInfoForm(DuibaGuessOptionsEntity guessOptionsEntity) {
		return update("updateInfoForm", guessOptionsEntity);
	}

	@Override
	public int updateRemainingById(Long id, Integer remaining) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("remaining", remaining);
		return update("updateRemainingById", paramMap);
	}
	
	/**
	 * 这个方法延迟到子类实现,由子类决定注入哪个sqlSessionTemplate,以使用不同的库
	 *
	 * @return
	 */
	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.GUESS;
	}
}
