package cn.com.duiba.activity.center.biz.dao.manuallottery.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.manuallottery.AppManualLotteryDao;
import cn.com.duiba.activity.center.biz.entity.manual.AppManualLotteryEntity;

@Repository
public class AppManualLotteryDaoImpl extends ActivityBaseDao implements AppManualLotteryDao {

    @Override
    public List<AppManualLotteryEntity> scanOverManualLottery() {
        return selectList("scanOverManualLottery");
    }

    @Override
    public void updateManualLottery(AppManualLotteryEntity appManualLottery) {
        update("updateManualLottery", appManualLottery);
    }

    @Override
    public List<AppManualLotteryEntity> findAllByIds(List<Long> ids) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("ids", ids);
        return selectList("findAllByIds", map);
    }

    @Override
    public void insert(AppManualLotteryEntity AppManualLotteryEntity) {
        insert("insert", AppManualLotteryEntity);
    }

    @Override
    public void update(AppManualLotteryEntity AppManualLotteryEntity) {
        update("update", AppManualLotteryEntity);
    }

    @Override
    public AppManualLotteryEntity find(Long id) {
        return selectOne("find", id);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}
