package cn.com.duiba.activity.center.biz.dao.ngame.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.ngame.NgameOrdersExtendDao;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameOrdersExtendEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

@Repository
public class NgameOrdersExtendDaoImpl extends ActivityBaseDao implements NgameOrdersExtendDao {

	@Override
	public String findGameData(Long gameOrdersId) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("gameOrdersId", gameOrdersId);
		return selectOne("findGameData", params);
	}

	@Override
	public NgameOrdersExtendEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	@Override
	public void insert(NgameOrdersExtendEntity ngameOrdersExtendDto) {
		insert("insert", ngameOrdersExtendDto);
	}

	@Override
	public int updateGameData(Long id, String gameData) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("gameData", gameData);
		return update("updateGameData", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.NGAME;
	}
}
