package cn.com.duiba.activity.center.biz.dao.quizz.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzOptionsDao;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzOptionsEntity;

@Repository
public class DuibaQuizzOptionsDaoImpl extends ActivityBaseDao implements DuibaQuizzOptionsDao {

    @Override
    public List<DuibaQuizzOptionsEntity> findOptionsByQuizzId(Long duibaQuizzId) {
        return selectList("findOptionsByQuizzId", duibaQuizzId);
    }

    public List<DuibaQuizzOptionsEntity> findOptionsByQuizzIds(List<Long> duibaQuizzIds){
        if(duibaQuizzIds == null || duibaQuizzIds.isEmpty()){
            return Collections.emptyList();
        }
        Map<String,Object> params = new HashMap<>();
        params.put("duibaQuizzIds", duibaQuizzIds);
        return selectList("findOptionsByQuizzIds", params);
    }

    @Override
    public DuibaQuizzOptionsEntity find(Long id) {
        return selectOne("find", id);
    }

    @Override
    public int delete(List<Long> ids) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("ids", ids);
        return update("delete", params);
    }

    @Override
    public void insert(DuibaQuizzOptionsEntity quizzOptionsDO) {
        insert("insert", quizzOptionsDO);
    }

    @Override
    public int updateInfoForm(DuibaQuizzOptionsEntity quizzOptionsDO) {
        return update("updateInfoForm", quizzOptionsDO);
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("remaining", remaining);
        return update("updateRemainingById", paramMap);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.QUIZZ;
    }
}
