/**
 * Project Name:activity-center-biz
 * File Name:ConsumerCreditsServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.plugin.buckle
 * Date:2016年7月28日下午2:04:34
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.plugin.buckle.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;
import cn.com.duiba.activity.center.api.dto.other.NotifyQueueDO;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.biz.constant.Environment;
import cn.com.duiba.activity.center.biz.dao.other.DuibaRemainingMoneyDAO;
import cn.com.duiba.activity.center.biz.dao.other.NotifyQueueDAOImpl;
import cn.com.duiba.activity.center.biz.exception.DeveloperConsumeFailedException;
import cn.com.duiba.activity.center.biz.kafka.MessageService;
import cn.com.duiba.activity.center.biz.kafka.TopicConstant;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCreditsCallback;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCreditsService;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumeCreditsFailEvent;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumerCreditsSuccessEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent.ActivityOrderPluginContext;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent.ActivityOrdersEventType;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.activity.center.biz.service.prize.ActivityPrizeOptionService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobConfigService;
import cn.com.duiba.activity.center.biz.tools.AssembleTool;
import cn.com.duiba.activity.center.biz.tools.service.ActualPriceCalService;
import cn.com.duiba.activity.center.biz.tools.service.FrequentExchangeLimitService;
import cn.com.duiba.activity.center.biz.tools.service.ItemKeyStockServcie;
import cn.com.duiba.activity.center.biz.tools.service.TimeLimitService;
import cn.com.duiba.activity.center.biz.utils.MemLock;
import cn.com.duiba.activity.center.common.util.LogUtil;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.dcommons.flowwork.ActivityLotteryFlowworkService;
import cn.com.duiba.notifycenter.client.NotifyCenterServiceClient;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemoteAddrLimitService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:ConsumerCreditsServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月28日 下午2:04:34 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class ConsumerCreditsServiceImpl implements ConsumerCreditsService{

    private static Logger log = LoggerFactory.getLogger(ConsumerCreditsServiceImpl.class);
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private TodayRobConfigService todayRobConfigService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private ConsumerCreditsCallback consumerCreditsCallback;
    @Autowired
    private ActivityPrizeOptionService activityPrizeOptionService;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private TimeLimitService timeLimitService;
    @Autowired
    private ItemKeyStockServcie itemKeyStockServcie;
    @Autowired
    private RemoteAddrLimitService remoteAddrLimitService;
    @Autowired
    private ActualPriceCalService actualPriceCalService;
    @Autowired
    private DuibaRemainingMoneyDAO duibaRemainingMoneyDAO;
    @Autowired
    private FrequentExchangeLimitService frequentExchangeLimit;
    @Autowired @Qualifier("notifyQueueDAO")
    private NotifyQueueDAOImpl notifyQueueDAO;
    @Autowired
    private NotifyCenterServiceClient notifyCenterServiceClient;
    @Autowired
    private ActivityLotteryFlowworkService activityLotteryFlowworkService;
    @Autowired
    private ActPreStockSerivce actPreStockSerivce;
    
    /**
     * 消耗积分接口请求
     * @author zp
     * @param consumerId
     * @param acitivtyOrderId
     * @param transer 请求我们系统时自带，不重要
     * @param description 描述 如 "今日必抢："+todayRobConfigDto.getTitle(); 
     * @since JDK 1.6
     */
    @Override
    public void asyncConsumerCredits(Long consumerId,String orderNum,String transer,String ip,String description){
        
        DubboResult<ActivityOrderDto> order = remoteActivityOrderService.findByOrderNum(orderNum);
        if(!order.isSuccess() || order.getResult() == null){
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setAppId(order.getResult().getAppId().toString());
            message.setRelationId(order.getResult().getOrderNum());
            message.setRelationType(order.getResult().getActivityType());
            Map<String,String> params = Maps.newHashMap();
            params.put("ip", ip);
            message.setParams(params);
            onCreditsFail(message,new Exception("订单号不存在"));
            return;
        }
        //判断订单是否为扣积分状态
        if(order.getResult().getConsumeCreditsStatus() != ActivityOrderDto.ConsumeCreditsProcessing){
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setAppId(order.getResult().getAppId().toString());
            message.setRelationId(order.getResult().getOrderNum());
            message.setRelationType(order.getResult().getActivityType());
            Map<String,String> params = Maps.newHashMap();
            params.put("ip", ip);
            message.setParams(params);
            onCreditsSuccess(message);
            return;
        }
        //若积分为0
        if(order.getResult().getConsumeCredits() <= 0){
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setAppId(order.getResult().getAppId().toString());
            message.setRelationId(order.getResult().getOrderNum());
            message.setRelationType(order.getResult().getActivityType());
            Map<String,String> params = Maps.newHashMap();
            params.put("ip", ip);
            message.setParams(params);
            onCreditsSuccess(message);
            return;
        }
        ConsumerDO consumer = remoteConsumerService.find(consumerId);
        AppDO app = remoteAppService.find(consumer.getAppId());
        CreditConsumeParams p = new CreditConsumeParams();
        p.setAppKey(app.getAppKey());
        p.setCredits(order.getResult().getConsumeCredits());
        p.setOrderNum("activity-" + order.getResult().getOrderNum());
        p.setUid(consumer.getPartnerUserId());
        p.setTimestamp(new Date());
        p.setType(order.getResult().getActivityType());
        p.setIp(order.getResult().getIp());
        p.setFacePrice(0);
        p.setActualPrice(0);
       // update  chengdeman  2016-09-18  抽象描述，增加减积分的公用性
       /* if(order.getResult().getActivityType().equals(ActivityOrderDto.TypeRob)){
            TodayRobConfigDto robDto = todayRobConfigService.find(order.getResult().getDuibaActivityId());
            p.setDescription("今日必抢:" + robDto.getTitle());
        }*/
        p.setDescription(description);
        if(StringUtils.isNotBlank(transer)){
            p.setTransfer(transer);
        }
        Map<String,String> map = p.toRequestMap(app.getAppSecret());
        
        CreditsMessage mq = new CreditsMessage();
        mq.setTimestamp(System.currentTimeMillis());
        mq.setAppId(order.getResult().getAppId().toString());
        mq.setConsumerId(order.getResult().getConsumerId().toString());
        mq.setRelationId(order.getResult().getOrderNum());
        mq.setRelationType(order.getResult().getActivityType());
        Map<String,String> params = Maps.newHashMap();
        params.put("ip", ip);
        mq.setParams(params);
        // 如果是百度云环境，使用post方式
        if (Environment.PlaceBaiduyun.equals(Environment.getPlace())) {
            mq.setHttpUrl(app.getCreditsConsumeRequestUrl());
            mq.setHttpType(CreditsMessage.HTTP_POST);
            mq.setAuthParams(map);
        } else {
            String url = AssembleTool.assembleUrl(app.getCreditsConsumeRequestUrl(), map);
            mq.setHttpUrl(url);
            mq.setHttpType(CreditsMessage.HTTP_GET);
        }
        String str = JSONObject.toJSONString(mq);
        try{
            log.error("->>发送kafka扣积分信息," + str);
            messageService.sendMsg(topicConstant.getTopicConsumerCredits(),str,2000);
        }catch(Exception e){
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setAppId(order.getResult().getAppId().toString());
            message.setRelationId(order.getResult().getOrderNum());
            message.setRelationType(order.getResult().getActivityType());
            Map<String,String> paramss = Maps.newHashMap();
            paramss.put("ip", ip);
            message.setParams(paramss);
            onCreditsFail(message,e);
            return;
        }
    }
    
    @Override
    public void onCreditsFail(CreditsCallbackMessage message,Exception exception){
        ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
        try {
            ActivityOrderDto o4u = new ActivityOrderDto();
            if ((exception instanceof DeveloperConsumeFailedException) && ((DeveloperConsumeFailedException) exception).getNormalFail()) {
                o4u.setError4admin("扣积分失败，开发者返回扣积分失败。" + exception.getMessage());
                o4u.setError4developer("扣积分失败，开发者返回扣积分失败。");
                o4u.setError4consumer("抽奖失败，请稍后再试。");
            } else {
                o4u.setError4admin("扣积分失败，开发者服务器异常。" + exception.getMessage());
                o4u.setError4developer("扣积分失败，" + exception.getMessage());
                o4u.setError4consumer("抽奖失败，请稍后再试。");
            }
            remoteActivityOrderService.consumeCreditsFail(order.getOrderNum(),null, null, 
                                                          null, null, null, null, null, null, null,
                                                          o4u.getError4admin(),o4u.getError4developer(),o4u.getError4consumer());
            // 返还本地积分
            if (order.getConsumeCredits() > 0) {
                remoteConsumerService.increaseCredits(order.getConsumerId(), order.getConsumeCredits());
            }
        } catch (Exception e) {
            log.error("活动抽奖异常:", e);
        } finally {
            complete(order.getOrderNum());
            // 发出扣积分失败事件
            DuibaEventsDispatcher.get().dispatchConsumeCreditsFailEvent(new ConsumeCreditsFailEvent(order, exception));
        }
    }
    
    @Override
    public void onCreditsSuccess(CreditsCallbackMessage message){
        String ip = message.getParams().get("ip");
        ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
        List<ActivityPrizeOptionDto> options = Lists.newArrayList();
        if(order.getActivityType().equals(ActivityOrderDto.TypeRob)){
            options = activityPrizeOptionService.queryActivityOptionsByConfigId(order.getDuibaActivityId(),ActivityPrizeOptionDto.Activity_Type_Rob);
        }
        //根据概率选取一个奖项
        ActivityPrizeOptionDto winOption = randomPrize(order.getDuibaActivityId(),order.getActivityType(), options);
        try{
            winOption = winOptionCheck(order,winOption,options);
            doWinPrize(order, winOption, options,ip);
        }catch(Exception e){
            log.error("抽奖异常:降级为优惠券", e);
            LogUtil.logTodayKan("ConsumerCreditsServiceImpl onCreditsSuccess 根据概率选取的一个奖项 winOption===>"+JSONObject.toJSONString(winOption));
            try{
                if(winOption.getPrizeType().equals(ItemDO.TypeObject)){
                    LogUtil.logTodayKan("ConsumerCreditsServiceImpl onCreditsSuccess 实物兑换失败 order===>"+JSONObject.toJSONString(order));
                    ActivityPrizeOptionDto option = awardCoupon(order.getDuibaActivityId(), order.getActivityType(), options);
                    winOption = winOptionCheck(order,option,options);
                    doWinPrize(order, winOption, options,ip);
                }else if(winOption.getPrizeType().equals(ItemDO.TypeCoupon)){
                    LogUtil.logTodayKan("ConsumerCreditsServiceImpl onCreditsSuccess 获取优惠券失败 order===>"+JSONObject.toJSONString(order));
                    try{
                        ActivityPrizeOptionDto option = awardThanks(order.getDuibaActivityId(), order.getActivityType());
                        doWinPrize(order, option, options,ip);
                    }catch(Exception e2){
                        log.error("抽奖异常: 降级为谢谢参与，仍然出错",e2);
                    }
                }
            }catch(Exception e1){
                log.error("抽奖异常,降级为优惠券出错:",e1);
                LogUtil.logTodayKan("ConsumerCreditsServiceImpl onCreditsSuccess finally 最终获取优惠券失败 order===>"+JSONObject.toJSONString(order));
                try{
                    ActivityPrizeOptionDto option = awardThanks(order.getDuibaActivityId(), order.getActivityType());
                    doWinPrize(order, option, options,ip);
                }catch(Exception e3){
                    log.error("抽奖异常: 降级为谢谢参与，仍然出错 ", e3);
                }
            }
        }finally{
            this.complete(order.getOrderNum());
            // 发出扣积分成功事件
            ActivityOrderDto orderNew = remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
            DuibaEventsDispatcher.get().dispatchConsumeCreditsSuccessEvent(new ConsumerCreditsSuccessEvent(orderNew));
        }
    }
    
    private ActivityPrizeOptionDto winOptionCheck(ActivityOrderDto order,ActivityPrizeOptionDto winOption,List<ActivityPrizeOptionDto> options){
        while(true){
            //验证奖项能否被抽中
            boolean optionCheck = validOptionCheck(order, winOption);
            //商品本身验证
            boolean itemCheck = validItemKeyCheck(order,winOption,optionCheck);
            if(!itemCheck){
                LogUtil.logTodayKan("winOptionCheck 商品本身验证失败 winOption===>"+JSONObject.toJSONString(winOption));
                if(winOption.getPrizeType().equals(ItemDO.TypeCoupon)){
                    LogUtil.logTodayKan("winOptionCheck coupon failed winOption===>"+JSONObject.toJSONString(winOption));
                    winOption = awardThanks(order.getDuibaActivityId(),order.getActivityType());
                    return winOption;
                }else{
                    winOption = awardCoupon(order.getDuibaActivityId(), order.getActivityType(), options);
                    LogUtil.logTodayKan("winOptionCheck awardCoupon success winOption===>"+JSONObject.toJSONString(winOption));
                }
            }else{
                return winOption;
            }
        }
    }
    
    public void doWinPrize(ActivityOrderDto order,ActivityPrizeOptionDto winOption,List<ActivityPrizeOptionDto> options,String ip) throws Exception{
        Long couponId = null;
        ActivityOrderPluginContext context = new ActivityOrderPluginContext();
        MemLock lock = new MemLock();
        lock.setLocked(false);
        try{
            if(winOption.getId() != null){
                lock = frequentExchangeLimit.lockPrize(order.getDuibaActivityId(),order.getActivityType(),winOption.getId());
                if(lock.isLocked()){
                    DuibaEventsDispatcher.get().triggerBeforeActivityOrderComplete(order, winOption, context);
                    Object obj = context.getAttribute("couponId");
                    if(null != obj){
                        couponId = (Long)obj;
                    }
                }else{
                    //降级
                    throw new Exception("降级处理");
                }
            }
            DubboResult<Boolean> result = remoteActivityOrderService.consumeCreditsSuccess(order.getOrderNum(),winOption.getId(),winOption.getPrizeName(),
                                                             winOption.getPrizeType(),winOption.getFacePrice(),winOption.getAppItemId(),
                                                             winOption.getItemId(),winOption.getgId(),winOption.getgType(),couponId);
            if(!result.isSuccess() || result.getResult() == null || !result.getResult()){
                throw new Exception("更新抽奖订失败");
            }
            remoteActivityOrderService.exchangeStatusToWait(order.getOrderNum());
        }catch(Exception e){
            if (lock.isLocked()) {
                DuibaEventsDispatcher.get().triggerOnActivityOrderCompleteException(order, winOption, e, context);
            }
            log.error("className: " + this.getClass().getName() + " method: doWinPrize", e);
            throw e;
        }finally{
            if(lock.isLocked()){
                frequentExchangeLimit.unlockPrize(order.getDuibaActivityId(),order.getActivityType(), winOption.getId());
            }
            //活动参与人数+1
            if(order.getActivityType().equals(ActivityOrderDto.TypeRob)){
                todayRobConfigService.updateVisitTime(order.getDuibaActivityId());
            }
        }
        if(!winOption.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)){
            //创建兑换记录
            activityLotteryFlowworkService.insertCosumerExchanageRecord(order.getConsumerId(), 
                                                                        order.getOrderNum(),null,winOption.getPrizeType());
        }
        //优惠券自动领奖
        if(winOption.getPrizeType().equals(ItemDO.TypeCoupon)){
            try{
                activityLotteryFlowworkService.autoTakePrize(order.getOrderNum(),order.getConsumerId(), order.getAppId(),ip, null);
            }catch(Exception e){
                log.error("优惠券领奖异常",e);
            }
        }
    }
    
    public void complete(String orderNum) {
        // 查询最新订单信息
        ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(orderNum).getResult();
        // 通知开发者
        insertHdtoolOrderNotifyQueueIfNesscery(order);
        // 发出活动订单事件
        if (order.getConsumeCreditsStatus() == ActivityOrderDto.ConsumeCreditsSuccess) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEventType.OnOrderSuccess, order));
        } else if (order.getConsumeCreditsStatus() == ActivityOrderDto.ConsumeCreditsFail) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEventType.OnOrderFail, order));
        }
    }
    
    
    private void insertHdtoolOrderNotifyQueueIfNesscery(ActivityOrderDto order) {
        try {
            if (order.getConsumeCredits() <= 0) {
                return;
            }
            if (order.getConsumeCreditsStatus() == ActivityOrderDto.ConsumeCreditsProcessing) {
                return;
            }
            ConsumerDO consumer=remoteConsumerService.find(order.getConsumerId());
            
            NotifyQueueDO nq=new NotifyQueueDO();
            nq.setAppId(order.getAppId());
            nq.setConsumerId(order.getConsumerId());
            nq.setDeveloperBizId(order.getDeveloperBizId());
            nq.setDuibaOrderNum("activity-" + order.getOrderNum());
            if (order.getError4developer() != null) {
                nq.setError4developer(order.getError4developer());
            }
            nq.setNextTime(new Date());
            nq.setPartnerUserId(consumer.getPartnerUserId());
            nq.setRelationId(order.getDuibaActivityId());
            nq.setRelationType(NotifyQueueDO.RTActivityRob);
            nq.setTimes(0);
            nq.setResult(order.getConsumeCreditsStatus() == ActivityOrderDto.ConsumeCreditsSuccess);
            notifyQueueDAO.insert(nq);
            notifyCenterServiceClient.notifyImmediately(nq.getId());
        } catch (Exception e) {
            log.error("insertHdtoolOrderNotifyQueueIfNesscery error",e);
        }
    }
    
    public boolean validOptionCheck(ActivityOrderDto order,ActivityPrizeOptionDto prize){
        //谢谢参与不再验证
        if(prize.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)){
            return true;
        }
        if(prize.getMinComein() != null){
            //保底人数校验
            int joinTime = 0;
            if(order.getActivityType().equals(ActivityOrderDto.TypeRob)){
                TodayRobConfigDto dto = todayRobConfigService.find(order.getDuibaActivityId());
                joinTime = dto.getVisitTime();
            }
            if(joinTime < prize.getMinComein()){
                return false;
            }
        }
        //奖项剩余个数验证
        ActPreStockDto preStock = actPreStockSerivce.findPreStockByApp(prize.getId(), ActivityPrizeOptionDto.Activity_Type_Rob, order.getAppId());
        Long stockId = prize.getStockId();
        if(null != preStock && preStock.getPrizeQuantity() != null){
            stockId = preStock.getPrizeQuantity();
        }
        DubboResult<Long> stockNum = remoteStockService.find(stockId);
        if(!stockNum.isSuccess() || null == stockNum.getResult() || stockNum.getResult() <= 0){
            return false;
        }
        return true;
    }
    
    public boolean validItemKeyCheck(ActivityOrderDto order,ActivityPrizeOptionDto prize,boolean check){
        if(!check){
            return false;
        }
        //谢谢参与不再验证
        if(prize.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)){
            return true;
        }
        ItemKey itemKey = remoteItemKeyService.getItemKeyIncludeDeleted(prize.getItemId(), prize.getAppItemId(), order.getAppId());
        if(itemKey == null){
            return false;
        }
        //兑吧商品禁用或删除
        if(itemKey.getItem() != null && (!itemKey.getItem().getEnable() || itemKey.getItem().getDeleted())){
            return false;
        }
        if(timeLimitService.isLimitItem(itemKey.getItem())){
            return false;
        }
        //APP兑换限制只能测试专用商品中奖
        if (!itemKey.getApp().isAppSwitch(AppDO.SwitchCloseAppTradingLimit)) {
            if (null != itemKey.getItem() && itemKey.getItem().getType().equals(ItemDO.TypeCoupon)) {
                if (!itemKey.getItem().getId().equals(191l)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        //奖项库存验证
        if(prize.getPrizeType().equals(ItemDO.TypeObject) || prize.getPrizeType().equals(ItemDO.TypeCoupon)){
            if(itemKeyStockServcie.findRemaining(itemKey) <= 0){
                return false;
            }
        }
        //优惠券批次校验
        if(!itemKeyStockServcie.couponBatchCheck(itemKey)){
            return false;
        }
        // 实物自动下架失效过期验证，自动关闭
        if (ItemDO.TypeObject.equals(itemKey.getItemType())) {
            if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
                if (itemKey.getItem().getValidEndDate() != null && new Date().after(itemKey.getItem().getValidEndDate())) {
                    return false;
                }
                if (itemKey.getItem().getAutoOffDate() != null && new Date().after(itemKey.getItem().getAutoOffDate())) {
                    return false;
                }
            }
        }
        //地域限制验证
        List<ItemKeyVO> itemKeyVOs = Lists.newArrayList(new ItemKeyVO(itemKey));
        itemKeyVOs = remoteAddrLimitService.mobileIndexAddrLimitFilter(itemKeyVOs, order.getIp());
        if(itemKeyVOs.isEmpty()){
            return false;
        }
        return true;
    }
    
    private ActivityPrizeOptionDto randomPrize(Long activityId,String activityType,List<ActivityPrizeOptionDto> options){
        double totalRate = 0;
        List<ActivityPrizeOptionDto> validOptions = Lists.newArrayList();
        for(ActivityPrizeOptionDto option : options){
            if(StringUtils.isNotBlank(option.getRate()) && Double.valueOf(option.getRate()) > 0.00001){
                totalRate = totalRate + Double.valueOf(option.getRate());
                validOptions.add(option);
            }
        }
        if(totalRate > 100){
            log.error("奖项概率和超过100%,duibaActivityId=" + activityId + ",activityType=" + activityType);
            return awardCoupon(activityId,activityType,options);
        }
        Collections.shuffle(validOptions);
        double randomNumber = Math.random() * 100;
        ActivityPrizeOptionDto winOption = null;
        double temp = 0.0;
        for(ActivityPrizeOptionDto dto : validOptions){
            temp += Double.valueOf(dto.getRate()).doubleValue();
            if (randomNumber <= temp) {
                winOption = dto;
                break;
            }
        }
        if(null == winOption){
            return awardCoupon(activityId,activityType,options);
        }
        return winOption;
    }
    
    private ActivityPrizeOptionDto awardCoupon(Long activityId,String activityType,List<ActivityPrizeOptionDto> options){
        List<ActivityPrizeOptionDto> couponOptions = Lists.newArrayList();
        for(ActivityPrizeOptionDto option : options){
            if(option.getPrizeType().equals(ItemDO.TypeCoupon)){
                couponOptions.add(option);
            }
        }
        if(couponOptions.isEmpty()){
            LogUtil.logTodayKan("ActivityPrizeOptionDto couponOptions is emputy,options===>"+JSONObject.toJSONString(options));
            return awardThanks(activityId,activityType);
        }
        Collections.shuffle(couponOptions);
        return couponOptions.get(0);
    }
    
    private ActivityPrizeOptionDto awardThanks(Long activityId,String activityType){
        ActivityPrizeOptionDto option = new ActivityPrizeOptionDto();
        option.setActivityId(activityId);
        option.setActivityType(activityType);
        option.setPrizeType(ActivityPrizeOptionDto.Prize_Type_Thanks);
        option.setPrizeName("谢谢参与");
        return option;
    }
    
    @Override
    public void creditsCallback(CreditsCallbackMessage message){
        if(null == message || StringUtils.isBlank(message.getRelationId())){
            return;
        }
        DubboResult<ActivityOrderDto> orderResult = remoteActivityOrderService.findByOrderNum(message.getRelationId());
        if(!orderResult.isSuccess() || orderResult.getResult() == null){
            return;
        }
        ActivityOrderDto order = orderResult.getResult();
        if(order.getConsumeCreditsStatus() != ActivityOrderDto.ConsumeCreditsProcessing){
            return;
        }
        if (CreditsCallbackMessage.CALLBACK_TYPE_COMPLETED.equals(message.getCallbackType())) {
            consumerCreditsCallback.completed(message);
        } else if (CreditsCallbackMessage.CALLBACK_TYPE_FAILED.equals(message.getCallbackType())) {
            consumerCreditsCallback.failed(message);
        } else if (CreditsCallbackMessage.CALLBACK_TYPE_CANCELLED.equals(message.getCallbackType())) {
            consumerCreditsCallback.cancelled(message);
        }
    }
}

