package cn.com.duiba.activity.center.biz.remoteservice.impl.creditgame;

import cn.com.duiba.activity.center.api.dto.creditgame.CreditGameDto;
import cn.com.duiba.activity.center.api.dto.creditgame.CreditGameResultDto;
import cn.com.duiba.activity.center.api.dto.creditgame.GamePreResultDto;
import cn.com.duiba.activity.center.api.dto.other.NotifyQueueDO;
import cn.com.duiba.activity.center.api.remoteservice.creditgame.RemoteCreditGameService;
import cn.com.duiba.activity.center.biz.constant.Environment;
import cn.com.duiba.activity.center.biz.dao.other.NotifyQueueDAOImpl;
import cn.com.duiba.activity.center.biz.entity.creditgame.CreditGameEntity;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCreditsService;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent.ActivityOrdersEventType;
import cn.com.duiba.activity.center.biz.service.creditgame.CreditGameService;
import cn.com.duiba.activity.center.biz.utils.message.DecrementCreditRequestMessage;
import cn.com.duiba.notifycenter.client.NotifyCenterServiceClient;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

/**
 * 积分游戏前台接口实现类
 */
@Service
@Slf4j
public class RemoteCreditGameServiceImpl implements RemoteCreditGameService {
	
	 private static Logger log = LoggerFactory.getLogger(RemoteCreditGameServiceImpl.class);
	
    @Autowired
    private CreditGameService creditGameService;
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private ConsumerCreditsService consumerCreditsService;
    
    @Autowired @Qualifier("notifyQueueDAO")
    private NotifyQueueDAOImpl notifyQueueDAO;
    @Autowired
    private NotifyCenterServiceClient notifyCenterServiceClient;
    
    /**
     * paly游戏(生成游戏订单、扣除积分)
     * @param creditGameId 积分游戏ID
     * @param consumerId 用户ID
     * @param creditGameStepRecordId 积分游戏步骤记录ID
     * @param creditGamesRuntimeParameters 积分游戏参数Map
     * @return 积分游戏前置结果
     */
    public DubboResult<GamePreResultDto> palyCreditGame(Long creditGameId,Long consumerId,String creditGameStepRecordId,Map<String,Object> creditGamesRuntimeParameters){
    	
    	
    	return DubboResult.failResult("未实现");
    }

    @Override
    public DubboResult<CreditGameResultDto> getPalyCreditGameResult(Long creditGameOrderId){
        return DubboResult.failResult("未实现");
    }

    @Override
    public DubboResult<CreditGameDto> getCreditGameById(Long creditGameId){
        try {
            // 参数校验
            Preconditions.checkNotNull(creditGameId);

            CreditGameEntity creditGameEntity = creditGameService.queryById(creditGameId);
            CreditGameDto creditGameDto = new CreditGameDto();
            BeanUtils.copyProperties(creditGameDto, creditGameEntity);
            // 拼装积分游戏实体


            return DubboResult.successResult(creditGameDto);
        }catch(Throwable t){
//            log.error(t.getMessage(),t);
            return DubboResult.failResult(t.getMessage());
        }
    }

     //减积分
	@Override
	public DubboResult<String> decrementCredit(CreditGameDto creditGame,Long consumerId, String orderNum, Long credits,String ipAddress,String transfer){
		 // 扣除本地积分
        remoteConsumerService.decrementCredits(consumerId,credits);
        // TODO 发送请求异常需要补偿本地积分,通知开发者 (原有逻辑)
        String description = "今日必抢："+creditGame.getCreditGameTitle();
        consumerCreditsService.asyncConsumerCredits(consumerId, orderNum, transfer,ipAddress,description);
        
       // sendDecrementCreditRequestMessage(decrementCreditRequestMessage);
		return null;
	}

	//加积分
	@Override
	public DubboResult<String> incrementCredit(CreditGameDto creditGame, Long consumerId, 
			String orderNum, Long credits, String ipAddress,String transfer) {
		// TODO Auto-generated method stub
		return null;
	}

	// 增加、扣积分后发送通知
	@Override
	public DubboResult<String> crementCreditNotify(String orderNum) {
		 // 查询最新订单信息
        ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(orderNum).getResult();
        // 通知开发者
        insertHdtoolOrderNotifyQueueIfNesscery(order);
        // 发出活动订单事件
        if (order.getConsumeCreditsStatus() == ActivityOrderDto.ConsumeCreditsSuccess) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEventType.OnOrderSuccess, order));
        } else if (order.getConsumeCreditsStatus() == ActivityOrderDto.ConsumeCreditsFail) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEventType.OnOrderFail, order));
        }
        return DubboResult.successResult(order.getOrderNum());
	}
	
	//订单通知队列
	private void insertHdtoolOrderNotifyQueueIfNesscery(ActivityOrderDto order) {
        try {
            if (order.getConsumeCredits() <= 0) {
                return;
            }
            if (order.getConsumeCreditsStatus() == ActivityOrderDto.ConsumeCreditsProcessing) {
                return;
            }
            ConsumerDO consumer=remoteConsumerService.find(order.getConsumerId());
            
            NotifyQueueDO nq=new NotifyQueueDO();
            nq.setAppId(order.getAppId());
            nq.setConsumerId(order.getConsumerId());
            nq.setDeveloperBizId(order.getDeveloperBizId());
            nq.setDuibaOrderNum("activity-" + order.getOrderNum());
            if (order.getError4developer() != null) {
                nq.setError4developer(order.getError4developer());
            }
            nq.setNextTime(new Date());
            nq.setPartnerUserId(consumer.getPartnerUserId());
            nq.setRelationId(order.getDuibaActivityId());
            nq.setRelationType(NotifyQueueDO.RTActivityRob);
            nq.setTimes(0);
            nq.setResult(order.getConsumeCreditsStatus() == ActivityOrderDto.ConsumeCreditsSuccess);
            notifyQueueDAO.insert(nq);
            notifyCenterServiceClient.notifyImmediately(nq.getId());
        } catch (Exception e) {
            log.error("insertHdtoolOrderNotifyQueueIfNesscery error",e);
        }
    }
	
}
