package cn.com.duiba.activity.center.biz.service.activity.Impl;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.service.activity.ConsumerActivityLimitService;
import cn.com.duiba.activity.center.biz.support.RedisKeyFactory;
import cn.com.duiba.wolf.redis.RedisClient;

/**
 * 用户参与活动限制
 * 
 * @author Administrator
 *
 */
@Service
public class ConsumerActivityLimitServiceImpl implements ConsumerActivityLimitService {

	@Autowired
	private RedisClient redisClient;

	private long todayTTL = 60 * 60 * 24 * 1l; // 1天
	private long foreverTTL = 60 * 60 * 24 * 30 * 3 * 1l; // 3个月

	@Override
	public Integer findConsumerJoinNumToday(Long consumerId, Long operatingActivityId) {
		String value = redisClient.get(RedisKeyFactory.getConsumerJoinNumTodayKey(consumerId, operatingActivityId));
		if (StringUtils.isNotBlank(value)) {
			return Integer.valueOf(value);
		}
		return null;
	}

	@Override
	public boolean incrConsumerJoinNumToday(Long consumerId, Long operatingActivityId) {
		Integer joinNum = findConsumerJoinNumToday(consumerId, operatingActivityId);
		String key = RedisKeyFactory.getConsumerJoinNumTodayKey(consumerId, operatingActivityId);
		if (joinNum == null) {
			String ret = redisClient.set(key, "1", "nx", "ex", todayTTL);
			if (ret == null) {
				return false;
			}
		} else {
			redisClient.incr(key);
		}
		return true;
	}

	@Override
	public boolean decrConsumerJoinNumToday(Long consumerId, Long operatingActivityId) {
		Integer joinNum = findConsumerJoinNumToday(consumerId, operatingActivityId);
		String key = RedisKeyFactory.getConsumerJoinNumTodayKey(consumerId, operatingActivityId);
		if (joinNum != null) {
			redisClient.decr(key);
		}
		return true;
	}

	@Override
	public Integer findConsumerJoinNumForever(Long consumerId, Long operatingActivityId) {
		String value = redisClient.get(RedisKeyFactory.getConsumerJoinNumForeverKey(consumerId, operatingActivityId));
		if (StringUtils.isNotBlank(value)) {
			return Integer.valueOf(value);
		}
		return null;
	}

	@Override
	public boolean incrConsumerJoinNumForever(Long consumerId, Long operatingActivityId) {
		Integer joinNum = findConsumerJoinNumForever(consumerId, operatingActivityId);
		String key = RedisKeyFactory.getConsumerJoinNumForeverKey(consumerId, operatingActivityId);
		if (joinNum == null) {
			String ret = redisClient.set(key, "1", "nx", "ex", foreverTTL);
			if (ret == null) {
				return false;
			}
		} else {
			redisClient.incr(key);
		}
		return true;
	}

	@Override
	public boolean decrConsumerJoinNumForever(Long consumerId, Long operatingActivityId) {
		Integer joinNum = findConsumerJoinNumForever(consumerId, operatingActivityId);
		String key = RedisKeyFactory.getConsumerJoinNumForeverKey(consumerId, operatingActivityId);
		if (joinNum != null) {
			redisClient.decr(key);
		}
		return true;
	}

	@Override
	public Integer findConsumerFreeNumToday(Long consumerId, Long operatingActivityId) {
		String value = redisClient.get(RedisKeyFactory.getConsumerFreeNumTodayKey(consumerId, operatingActivityId));
		if (StringUtils.isNotBlank(value)) {
			return Integer.valueOf(value);
		}
		return null;
	}

	@Override
	public boolean incrConsumerFreeNumToday(Long consumerId, Long operatingActivityId) {
		Integer joinNum = findConsumerFreeNumToday(consumerId, operatingActivityId);
		String key = RedisKeyFactory.getConsumerFreeNumTodayKey(consumerId, operatingActivityId);
		if (joinNum == null) {
			String ret = redisClient.set(key, "1", "nx", "ex", todayTTL);
			if (ret == null) {
				return false;
			}
		} else {
			redisClient.incr(key);
		}
		return true;
	}

	@Override
	public boolean decrConsumerFreeNumToday(Long consumerId, Long operatingActivityId) {
		Integer joinNum = findConsumerFreeNumToday(consumerId, operatingActivityId);
		String key = RedisKeyFactory.getConsumerFreeNumTodayKey(consumerId, operatingActivityId);
		if (joinNum != null) {
			redisClient.decr(key);
		}
		return true;
	}

	@Override
	public Integer findConsumerFreeNumForever(Long consumerId, Long operatingActivityId) {
		String value = redisClient.get(RedisKeyFactory.getConsumerFreeNumForeverKey(consumerId, operatingActivityId));
		if (StringUtils.isNotBlank(value)) {
			return Integer.valueOf(value);
		}
		return null;
	}

	@Override
	public boolean incrConsumerFreeNumForever(Long consumerId, Long operatingActivityId) {
		Integer joinNum = findConsumerFreeNumForever(consumerId, operatingActivityId);
		String key = RedisKeyFactory.getConsumerFreeNumForeverKey(consumerId, operatingActivityId);
		if (joinNum == null) {
			String ret = redisClient.set(key, "1", "nx", "ex", foreverTTL);
			if (ret == null) {
				return false;
			}
		} else {
			redisClient.incr(key);
		}
		return true;
	}

	@Override
	public boolean decrConsumerFreeNumForever(Long consumerId, Long operatingActivityId) {
		Integer joinNum = findConsumerFreeNumForever(consumerId, operatingActivityId);
		String key = RedisKeyFactory.getConsumerFreeNumForeverKey(consumerId, operatingActivityId);
		if (joinNum != null) {
			redisClient.decr(key);
		}
		return true;
	}

	@Override
	public Integer findConsumerWinOptionNum(Long consumerId, Long operatingActivityId, String optionId) {
		String value = redisClient.get(RedisKeyFactory.getConsumerWinOptionNumKey(consumerId, operatingActivityId, optionId));
		if (StringUtils.isNotBlank(value)) {
			return Integer.valueOf(value);
		}
		return null;
	}

	@Override
	public boolean incrConsumerWinOptionNum(Long consumerId, Long operatingActivityId, String optionId) {
		Integer joinNum = findConsumerWinOptionNum(consumerId, operatingActivityId, optionId);
		String key = RedisKeyFactory.getConsumerWinOptionNumKey(consumerId, operatingActivityId, optionId);
		if (joinNum == null) {
			String ret = redisClient.set(key, "1", "nx", "ex", foreverTTL);
			if (ret == null) {
				return false;
			}
		} else {
			redisClient.incr(key);
		}
		return true;
	}

}
