package cn.com.duiba.activity.center.biz.service.creditgame.impl;

import java.util.List;

import cn.com.duiba.activity.center.biz.dao.GenericCURDDao;
import cn.com.duiba.activity.center.biz.dao.creditgame.CreditGameSkinTemplateDao;
import cn.com.duiba.activity.center.biz.entity.creditgame.CreditGameSkinTemplateEntity;
import cn.com.duiba.activity.center.biz.service.creditgame.CreditGameSkinTemplateService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.service.AbstractGenericCURDService;

/**
 * 积分游戏模板Service实现类
 * @author jyc
 * @since 2016-09-06
 */
@Service
public class CreditGameSkinTemplateServiceImpl extends AbstractGenericCURDService<CreditGameSkinTemplateEntity,Long> implements CreditGameSkinTemplateService {

    @Autowired
    private CreditGameSkinTemplateDao creditGameSkinTemplateDao;

    protected  GenericCURDDao<CreditGameSkinTemplateEntity, Long> getDao(){
        return creditGameSkinTemplateDao;
    }

    @Override
    public List<CreditGameSkinTemplateEntity> queryByPage(int offset, int max) {
        return this.creditGameSkinTemplateDao.selectByPage(offset, max);
    }

    @Override
    public Long queryCount() {
        return this.creditGameSkinTemplateDao.selectCount(null);
    }

    @Override
    public Long queryCountByName(String name) {
        return this.creditGameSkinTemplateDao.selectCount(name);
    }

    @Override
    public List<CreditGameSkinTemplateEntity> queryByType(byte type) {
        return this.creditGameSkinTemplateDao.selectByType(type);
    }
}
