package cn.com.duiba.activity.center.biz.service.plugin.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickDto;
import cn.com.duiba.activity.center.api.dto.direct.DuibaActivityAppSpecifyNewDto;
import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.api.remoteservice.direct.RemoteActivityBlackList4DeveloperService;
import cn.com.duiba.activity.center.biz.dao.activity_brick.PopupActivityBrickDao;
import cn.com.duiba.activity.center.biz.dao.plugin.ActivityPluginDao;
import cn.com.duiba.activity.center.biz.service.direct.DuibaActivityAppSpecifyNewService;
import cn.com.duiba.activity.center.biz.service.plugin.ActivityPluginService;
import cn.com.duiba.activity.center.common.util.DateUtil;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;

/** 
 * ClassName:ActivityPluginServiceImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月11日 下午4:21:45 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
@Service
public class ActivityPluginServiceImpl implements ActivityPluginService {
	
	private static Logger log = LoggerFactory.getLogger(ActivityPluginServiceImpl.class);
	@Autowired
	private ActivityPluginDao activityPluginDao;
	@Autowired
	private PopupActivityBrickDao popupActivityBrickDao;
	@Autowired
	private RemoteAppService remoteAppService;
	@Autowired
	private RemoteActivityBlackList4DeveloperService remoteActivityBlackList4DeveloperService;
    @Autowired
    private DuibaActivityAppSpecifyNewService duibaActivityAppSpecifyNewService;
	
	@Override
	public ActivityPluginDto createActivityPluginInfo(ActivityPluginDto activityPluginDto) {
		return activityPluginDao.createActivityPluginInfo(activityPluginDto);
	}

	@Override
	public Integer updateActivityPluginInfo(ActivityPluginDto activityPluginDto) {
		return activityPluginDao.updateActivityPluginInfo(activityPluginDto);
	}

	@Override
	public ActivityPluginDto findById(Long id) {
		return activityPluginDao.findById(id);
	}

	@Override
	public Integer OpenStatus(Long id,Integer value) {
		return activityPluginDao.OpenStatus(id,value);
	}

	@Override
	public List<ActivityPluginDto> findActivityPluginInfoList(Map<String, Object> map) {
		return activityPluginDao.findActivityPluginInfoList(map);
	}

	@Override
	public Long findPageCount(Map<String, Object> paramMap) {
		return activityPluginDao.findPageCount(paramMap);
	}

	@Override
	public Integer dellActivityPlugin(Long id) {
		return activityPluginDao.dellActivityPlugin(id);
	}

	@Override
	public PopupActivityBrickDto findActivityPlugInfo(Long appId,
			Long consumerId,String url) {
		//查询所有开启
		Map<String, Object> paramMap =new HashMap<String, Object>();
		paramMap.put("max", ActivityPluginDto.STATUS_OPEN);
		List<ActivityPluginDto> list =activityPluginDao.findActivityPluginInfoList(paramMap);
		//过滤不满足条件的活动
		ActivityPluginDto dto = filterActivityPluginDto(list,appId,url);
		if(dto == null ){
			return null;
		}
		PopupActivityBrickDto brickDto = popupActivityBrickDao.findById(dto.getBrickId());
		brickDto.setId(dto.getId());
		return brickDto;
	}

	@Override
	public String dojoin(Long activityPlugId, String activityType,
			Long consumerId, String ip, String ua, String transfer) {
		return null;
	}
	
	private ActivityPluginDto filterActivityPluginDto(
			List<ActivityPluginDto> list, Long appId,String url) {
		//过滤不满足条件的数据
		for(ActivityPluginDto dto:list){
			//过滤 不满足触发 事件的活动
			if(!dto.getScenarios().contains(url)){
				continue;
			}
			//过滤黑名单，定向数据
			if(filertBackInfo(dto,appId)){
				continue;
			}
			//查询活动子订单
			if(dto.getSignType()==ActivityPluginDto.SIGN_TYPE_FIRST){
				//活动有效期内首次登陆
				
			}else if(dto.getSignType()==ActivityPluginDto.SIGN_TYPE_EVERYFIRST){
				//活动有效期内每天首次登陆
				
			}else if(dto.getSignType()==ActivityPluginDto.SIGN_TYPE_EVERYTIME){
				//有效期内每次访问
				
			}else{
				//TODO 新人礼包
				
			}
			//判断时间是否满足开启条件
			for(String date:dto.getTriggerTime().split(",")){
				try{
					if (DateUtil.daysBetween(date)){
						return dto;
					}
				}catch (Exception e){
					log.error("触发事件格式错误："+date,e);
				}
			}
		}
		return null;
	}

	//黑名单和定向过滤
	private boolean filertBackInfo(ActivityPluginDto dto, Long appId) {
		AppDO app = remoteAppService.find(appId);
		//黑名单限制
		if(dto.isOpenSwitch(ActivityPluginDto.SWITCHES_DEV_BLACKLIST)){
			if(remoteActivityBlackList4DeveloperService.isExistBlackByActivityIdAndActivityTypeAndDeveloperId(dto.getId(),
							OperatingActivityDto.TypePlugin,app.getDeveloperId()).getResult()){
				return true;
			}
		}
		//定向App验证
		if(dto.isOpenSwitch(ActivityPluginDto.SWITCHES_DIRECT)){
			DuibaActivityAppSpecifyNewDto dtos = duibaActivityAppSpecifyNewService.findAppSpecifyByActivityIdAndAppIdAndActivityType(dto.getId(),appId, DuibaActivityAppSpecifyNewDto.ACTIVITY_HD_TYPE_PLUGIN);
			if(null == dtos){
				return true;
			}
		}
		return false;
	}

    @Override
    public int updateAutoOffDateNull(Date autoOffDate, Long id) {
        return activityPluginDao.updateAutoOffDateNull(autoOffDate, id);
    }

}