/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.bo.stock;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreChangeStockDto;
import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreChangeStockService;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.dcommons.domain.Tuple;
import cn.com.duiba.service.exception.BusinessException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActStockChangeBo {
    private static Logger log = LoggerFactory.getLogger(ActStockChangeBo.class);
    @Resource
    private ActPreStockSerivce actPreStockSerivce;
    @Autowired
    private ActPreChangeStockService actPreChangeStockService;

    @Transactional(value="creditsActivity")
    public Tuple.Tuple2<Integer, Integer> addActStockQuantity(Long prizeId, String relationType, Long appId, Long quantity) throws BusinessException {
        Tuple.Tuple2 tuple = null;
        ActPreStockDto preStock = null;
        preStock = appId.equals(0L) ? this.actPreStockSerivce.findPreStockByShare(prizeId, relationType) : this.actPreStockSerivce.findPreStockByApp(prizeId, relationType, appId);
        if (null == preStock) {
            throw new BusinessException(relationType + "\u6d3b\u52a8\uff1a\u5956\u9879\u9884\u5206\u914d\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        Long preStockId = preStock.getId();
        ActPreStockDto preStockLock = this.actPreStockSerivce.findByLock(preStockId);
        int result = this.actPreStockSerivce.addRemainingById(preStockId, quantity);
        if (result < 1) {
            throw new BusinessException("\u6dfb\u52a0\u6d3b\u52a8\u9884\u5206\u914d\u5956\u9879\u5e93\u5b58\u5931\u8d25");
        }
        tuple = Tuple.tuple((Object)quantity.intValue(), (Object)(preStockLock.getPrizeQuantity().intValue() + quantity.intValue()));
        ActPreChangeStockDto changeStock = new ActPreChangeStockDto(true);
        changeStock.setPreStockId(preStockId);
        changeStock.setRelationPrizeId(prizeId);
        changeStock.setRelationType(relationType);
        changeStock.setChangeQuantity(quantity);
        changeStock.setBeforeStock(preStockLock.getPrizeQuantity());
        changeStock.setAfterStock(Long.valueOf(preStockLock.getPrizeQuantity() + quantity));
        changeStock.setChangeKind("add");
        this.actPreChangeStockService.insert(changeStock);
        return tuple;
    }

    @Transactional(value="creditsActivity")
    public Tuple.Tuple2<Integer, Integer> reduceActStockQuantity(Long prizeId, String relationType, Long appId, Long quantity) throws BusinessException {
        Tuple.Tuple2 tuple = null;
        ActPreStockDto preStock = null;
        preStock = appId.equals(0L) ? this.actPreStockSerivce.findPreStockByShare(prizeId, relationType) : this.actPreStockSerivce.findPreStockByApp(prizeId, relationType, appId);
        if (null == preStock) {
            throw new BusinessException(relationType + "\u6d3b\u52a8\uff1a\u5956\u9879\u9884\u5206\u914d\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        Long preStockId = preStock.getId();
        ActPreStockDto preStockLock = this.actPreStockSerivce.findByLock(preStockId);
        if (preStockLock.getPrizeQuantity() <= quantity) {
            quantity = preStockLock.getPrizeQuantity();
            tuple = Tuple.tuple((Object)quantity.intValue(), (Object)0);
        } else {
            tuple = Tuple.tuple((Object)quantity.intValue(), (Object)(preStockLock.getPrizeQuantity().intValue() - quantity.intValue()));
        }
        int result = this.actPreStockSerivce.subRemainingById(preStockId, quantity);
        if (result < 1) {
            throw new BusinessException("\u51cf\u5c11\u6d3b\u52a8\u9884\u5206\u914d\u5956\u9879\u5e93\u5b58\u5931\u8d25");
        }
        ActPreChangeStockDto changeStock = new ActPreChangeStockDto(true);
        changeStock.setPreStockId(preStockId);
        changeStock.setRelationPrizeId(prizeId);
        changeStock.setRelationType(relationType);
        changeStock.setChangeQuantity(quantity);
        changeStock.setBeforeStock(preStockLock.getPrizeQuantity());
        changeStock.setAfterStock(Long.valueOf(preStockLock.getPrizeQuantity() - quantity));
        changeStock.setChangeKind("sub");
        this.actPreChangeStockService.insert(changeStock);
        return tuple;
    }

    public ActPreStockDto findActValidStock(Long relationPrizeId, String relationType, Long appId) {
        ActPreStockDto preStock = this.actPreStockSerivce.findPreStockByApp(relationPrizeId, relationType, appId);
        if (null == preStock) {
            preStock = this.actPreStockSerivce.findPreStockByShare(relationPrizeId, relationType);
        }
        return preStock;
    }
}

