/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.prize;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.api.remoteservice.prize.RemoteActivityPrizeOptionService;
import cn.com.duiba.activity.center.biz.service.prize.ActivityPrizeOptionService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteActivityPrizeOptionServiceImpl
implements RemoteActivityPrizeOptionService {
    private static Logger log = LoggerFactory.getLogger(RemoteActivityPrizeOptionServiceImpl.class);
    @Autowired
    private ActivityPrizeOptionService activityPrizeOptionService;
    @Autowired
    private RemoteStockService remoteStockService;

    public DubboResult<Boolean> delOption(Long optionId) {
        return DubboResult.successResult((Object)this.activityPrizeOptionService.deleteOption(optionId));
    }

    public DubboResult<Long> saveOrUpdateOption(ActivityPrizeOptionDto prizeOption) {
        return DubboResult.successResult((Object)this.activityPrizeOptionService.saveOrUpdateOption(prizeOption));
    }

    public DubboResult<List<ActivityPrizeOptionDto>> queryActivityOptionsByConfigId(Long configId, String activityType) {
        return DubboResult.successResult(this.activityPrizeOptionService.queryActivityOptionsByConfigId(configId, activityType));
    }

    public DubboResult<ActivityPrizeOptionDto> find(Long id) {
        return DubboResult.successResult((Object)this.activityPrizeOptionService.find(id));
    }

    public DubboResult<List<ActivityPrizeOptionDto>> queryActivityOptionsByConfigIds(List<Long> configIds, String activityType) {
        return DubboResult.successResult(this.activityPrizeOptionService.queryActivityOptionsByConfigIds(configIds, activityType));
    }

    public DubboResult<List<ActivityPrizeOptionDto>> queryActivityOptionByActivityType(String activityType, Integer offset, Integer max) {
        try {
            if (offset == null) {
                offset = 0;
            }
            if (max == null) {
                max = 20;
            }
            List<ActivityPrizeOptionDto> dtos = this.activityPrizeOptionService.queryActivityOptionsByActivityType(activityType, offset, max);
            return DubboResult.successResult(dtos);
        }
        catch (Exception e) {
            log.error("RemoteActivityPrizeOptionService.queryActivityOptionByActivityType(" + activityType + "," + offset + "," + max + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> queryCountByActivityType(String activityType) {
        try {
            Long count = this.activityPrizeOptionService.queryCountByActivityType(activityType);
            return DubboResult.successResult((Object)count);
        }
        catch (Exception e) {
            log.error("RemoteActivityPrizeOptionService.queryCountByActivityType(" + activityType + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ActivityPrizeOptionDto>> queryRandomGift(Integer number, List<Long> ids) {
        try {
            List<Object> rs;
            if (number == null) {
                return DubboResult.failResult((String)"\u8bf7\u8f93\u5165\u67e5\u8be2\u7684\u4e2a\u6570");
            }
            List<ActivityPrizeOptionDto> dtos = this.activityPrizeOptionService.queryActivityOptionsByActivityType(ActivityPrizeOptionDto.Special_Activity_Type_gift, null, null);
            if (CollectionUtils.isNotEmpty(dtos)) {
                ArrayList pId = Lists.newArrayList();
                ArrayList stockIds = Lists.newArrayList();
                HashMap stockPrizeMap = Maps.newHashMap();
                for (ActivityPrizeOptionDto dto : dtos) {
                    if (dto.getStockId() == null) continue;
                    stockIds.add(dto.getStockId());
                    stockPrizeMap.put(dto.getStockId(), dto.getId());
                }
                Map stockMap = (Map)this.remoteStockService.findBatch((List)stockIds).getResult();
                for (Long stockId : stockIds) {
                    Long prizeId;
                    Long stockValue = (Long)stockMap.get(stockId);
                    if (stockValue == null || stockValue > 0L || (prizeId = (Long)stockPrizeMap.get(stockId)) == null) continue;
                    pId.add(prizeId);
                }
                if (ids == null) {
                    ids = Lists.newArrayList();
                }
                ids.addAll(pId);
                rs = this.activityPrizeOptionService.queryRandomByActivityType(ActivityPrizeOptionDto.Special_Activity_Type_gift, number, ids);
            } else {
                rs = Lists.newArrayList();
            }
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("RemoteActivityPrizeOptionService.queryRandomGift error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

