/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.activity.Impl;

import cn.com.duiba.activity.center.api.dto.ActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.biz.dao.activity.OperatingActivityDao;
import cn.com.duiba.activity.center.biz.entity.activity.OperatingActivityEntity;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperatingActivityServiceImpl
implements OperatingActivityService {
    @Autowired
    private OperatingActivityDao operatingActivityDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "activity-keyOperatingActivityById_" + id;
    }

    @Override
    public List<OperatingActivityDto> findGameByAppIdAndActivityId(Long appId, List<Long> duibaActivityIds, Integer type) {
        return BeanUtils.copyList(this.operatingActivityDao.findGameByAppIdAndActivityId(appId, duibaActivityIds, type), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllAppTasksContent(Long appId) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllAppTasksContent(appId), OperatingActivityDto.class);
    }

    @Override
    public List<Long> findOpenLotteryIds() {
        return this.operatingActivityDao.findOpenLotteryIds();
    }

    @Override
    public List<OperatingActivityDto> findAllOpenDuibaActivity(Long duibaActivityId) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllOpenDuibaActivity(duibaActivityId), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaActivityIdAndDeleted(Long appId, Long duibaActivityId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndDuibaActivityIdAndDeleted(appId, duibaActivityId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaTurntableIdAndDeleted(Long appId, Long duibaTurntableId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndDuibaTurntableIdAndDeleted(appId, duibaTurntableId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndGameConfigDuibaIdAndDeleted(Long appId, Long gameConfigDuibaId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndGameConfigDuibaIdAndDeleted(appId, gameConfigDuibaId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaSingleLotteryIdAndDeleted(Long appId, Long duibaSingleLotteryId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndDuibaSingleLotteryIdAndDeleted(appId, duibaSingleLotteryId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaQuestionAnswerIdAndDeleted(Long appId, Long duibaQuestionAnswerId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndDuibaQuestionAnswerIdAndDeleted(appId, duibaQuestionAnswerId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaSeckillIdAndDeleted(Long appId, Long duibaSeckillId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndDuibaSeckillIdAndDeleted(appId, duibaSeckillId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaHdtoolIdAndDeleted(Long appId, Long duibaHdtoolId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndDuibaHdtoolIdAndDeleted(appId, duibaHdtoolId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaQuizzIdAndDeleted(Long appId, Long duibaQuizzId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndDuibaQuizzIdAndDeleted(appId, duibaQuizzId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndAppSingleLotteryIdAndDeleted(Long appId, Long appSingleLotteryId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndAppSingleLotteryIdAndDeleted(appId, appSingleLotteryId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndAppManualLotteryAndDeleted(Long appId, Long appManualLotteryId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndAppManualLotteryAndDeleted(appId, appManualLotteryId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public Long countActivity(Map<String, Object> params) {
        return this.operatingActivityDao.countActivity(params);
    }

    @Override
    public List<ActivityDto> findActivityList(Map<String, Object> params) {
        return BeanUtils.copyList(this.operatingActivityDao.findActivityList(params), ActivityDto.class);
    }

    @Override
    public List<ActivityDto> findRecommendActivityList(Long appId) {
        return BeanUtils.copyList(this.operatingActivityDao.findRecommendActivityList(appId), ActivityDto.class);
    }

    @Override
    public List<ActivityDto> findActivityListByParent(Map<String, Object> params) {
        return BeanUtils.copyList(this.operatingActivityDao.findActivityListByParent(params), ActivityDto.class);
    }

    @Override
    public Integer deleteTurntable(Long turntableId, Long appId, Boolean delete, Integer status) {
        Integer result = this.operatingActivityDao.deleteTurntable(turntableId, appId, delete, status);
        this.cacheClient.remove(this.getCacheKeyById(turntableId));
        return result;
    }

    @Override
    public List<Long> findAppIdsByDuibaActivityId(Long duibaActivityId) {
        return this.operatingActivityDao.findAppIdsByDuibaActivityId(duibaActivityId);
    }

    @Override
    public List<Long> findAppIdsBySingleLotteryId(Long singleLotteryId) {
        return this.operatingActivityDao.findAppIdsBySingleLotteryId(singleLotteryId);
    }

    @Override
    public List<Long> findAppIdsByActivityIdAndType(Long activityId, Integer type) {
        return this.operatingActivityDao.findAppIdsByActivityIdAndType(activityId, type);
    }

    @Override
    public List<Long> findAppIdsByDuibaSingleLotteryId(Long duibaSingleLotteryId) {
        return this.operatingActivityDao.findAppIdsByDuibaSingleLotteryId(duibaSingleLotteryId);
    }

    @Override
    public Integer countAppByActivityIdAndType(Long activityId, Integer type) {
        return this.operatingActivityDao.countAppByActivityIdAndType(activityId, type);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaActivityIds(List<Long> daIdList) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaActivityIds(daIdList), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByActivityIdsAndType(List<Long> activityIds, Integer type) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByActivityIdsAndType(activityIds, type), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSingleLotteryIds(List<Long> dslIdList) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaSingleLotteryIds(dslIdList), OperatingActivityDto.class);
    }

    @Override
    public List<Long> findIdsByDuibaActivityId(Long duibaActivityId) {
        return this.operatingActivityDao.findIdsByDuibaActivityId(duibaActivityId);
    }

    @Override
    public int updateStatusByDuibaActivityId(Integer status, Long duibaActivityId) {
        List<Long> ids = this.operatingActivityDao.findIdsByDuibaActivityIdAndType(duibaActivityId, 0);
        int result = this.operatingActivityDao.updateStatusByDuibaActivityId(status, duibaActivityId);
        for (Long id : ids) {
            this.cacheClient.remove(this.getCacheKeyById(id));
        }
        return result;
    }

    @Override
    public int updateStatusBySingleLotteryId(Integer status, Long singleLotteryId) {
        List<Long> ids = this.operatingActivityDao.findIdsByDuibaActivityIdAndType(singleLotteryId, 2);
        int result = this.operatingActivityDao.updateStatusBySingleLotteryId(status, singleLotteryId);
        for (Long id : ids) {
            this.cacheClient.remove(this.getCacheKeyById(id));
        }
        return result;
    }

    @Override
    public int updateVisitTimes(Long id) {
        int result = this.operatingActivityDao.updateVisitTimes(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return result;
    }

    @Override
    public List<Long> findIdsBySingleLotteryId(Long duibaSingleLotteryId) {
        return this.operatingActivityDao.findIdsBySingleLotteryId(duibaSingleLotteryId);
    }

    @Override
    public List<OperatingActivityDto> findAllByType(Integer type) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByType(type), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllBySingleLotteryId(Long duibaSingleLotteryId) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllBySingleLotteryId(duibaSingleLotteryId), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllBySingleLotteryIdAndDeleted(Long duibaSingleLotteryId, Boolean deleted) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllBySingleLotteryIdAndDeleted(duibaSingleLotteryId, deleted), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSeckillIdAndDeleted(Long duibaSeckillId, Boolean deleted) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaSeckillIdAndDeleted(duibaSeckillId, deleted), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaActivityId(Long duibaActivityId) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaActivityId(duibaActivityId), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSecondsKillId(Long duibaSecondsKillId) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaSecondsKillId(duibaSecondsKillId), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaActivityIdAndDeleted(Long duibaActivityId, Boolean deleted) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaActivityIdAndDeleted(duibaActivityId, deleted), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaQuestionAnswerIdAndDeleted(Long duibaQuestionAnswerId, Boolean deleted) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaQuestionAnswerIdAndDeleted(duibaQuestionAnswerId, deleted), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaQuizzIdAndDeleted(Long duibaQuizzId, Boolean deleted) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaQuizzIdAndDeleted(duibaQuizzId, deleted), OperatingActivityDto.class);
    }

    @Override
    public void updateStatusByActivityIdAndType(Long activityId, Integer type, Integer status) {
        List<Long> ids = this.operatingActivityDao.findIdsByDuibaActivityIdAndType(activityId, type);
        this.operatingActivityDao.updateStatusByActivityIdAndType(activityId, type, status);
        for (Long id : ids) {
            this.cacheClient.remove(this.getCacheKeyById(id));
        }
    }

    @Override
    public OperatingActivityDto findByActivityIdAndTypeAndAppIdAndDeleted(Long activityId, Integer type, Long appId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByActivityIdAndTypeAndAppIdAndDeleted(activityId, type, appId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public List<Long> findIdsByDuibaActivityIdAndType(Long duibaActivityId, Integer type) {
        return this.operatingActivityDao.findIdsByDuibaActivityIdAndType(duibaActivityId, type);
    }

    @Override
    public List<OperatingActivityDto> findSingleLotteryOperaList(List<Long> activityIds, Long appId) {
        return BeanUtils.copyList(this.operatingActivityDao.findSingleLotteryOperaList(activityIds, appId), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByActivityIdAndParentIdAndTypeAndAppId(Long duibaActivityId, Long parentActivityId, Integer type, Long appId) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByActivityIdAndParentIdAndTypeAndAppId(duibaActivityId, parentActivityId, type, appId)), OperatingActivityDto.class);
    }

    @Override
    public void deleteByParentActivityIds(List<Long> parentIds) {
        List<Long> ids = this.operatingActivityDao.findIdsByParentIdsAndType(parentIds, 2);
        this.operatingActivityDao.deleteByParentActivityIds(parentIds);
        for (Long id : ids) {
            this.cacheClient.remove(this.getCacheKeyById(id));
        }
    }

    @Override
    public OperatingActivityDto findOperatingSingleLottery(Long activityId, Long appId) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findOperatingSingleLottery(activityId, appId)), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByIds(ids), OperatingActivityDto.class);
    }

    @Override
    public int updateManualLotteryByIds(List<Long> ids) {
        int result = this.operatingActivityDao.updateManualLotteryByIds(ids);
        for (Long id : ids) {
            this.cacheClient.remove(this.getCacheKeyById(id));
        }
        return result;
    }

    @Override
    public List<OperatingActivityDto> findAllEnabledActivies(Long appId) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllEnabledActivies(appId), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findActiveActivity(Long appId) {
        return BeanUtils.copyList(this.operatingActivityDao.findActiveActivity(appId), OperatingActivityDto.class);
    }

    @Override
    public List<Long> findAllVirtualInTurntable(Long appId) {
        return this.operatingActivityDao.findAllVirtualInTurntable(appId);
    }

    @Override
    public List<Long> findAllVirtualInSingleLottery(Long appId) {
        return this.operatingActivityDao.findAllVirtualInSingleLottery(appId);
    }

    @Override
    public List<Long> findAllVirtualInHdTool(Long appId) {
        return this.operatingActivityDao.findAllVirtualInHdTool(appId);
    }

    @Override
    public OperatingActivityDto find(final Long id) {
        return (OperatingActivityDto)this.cacheClient.getWithCacheLoader(this.getCacheKeyById(id), 10, TimeUnit.MINUTES, (CacheLoader)new CacheLoader<OperatingActivityDto>(){

            public OperatingActivityDto load() {
                return (OperatingActivityDto)BeanUtils.copy((Object)((Object)OperatingActivityServiceImpl.this.operatingActivityDao.find(id)), OperatingActivityDto.class);
            }
        });
    }

    @Override
    public void insert(OperatingActivityDto operatingActivityDto) {
        OperatingActivityEntity entity = new OperatingActivityEntity(true);
        BeanUtils.copy((Object)operatingActivityDto, (Object)((Object)entity));
        this.operatingActivityDao.insert(entity);
        operatingActivityDto.setId(entity.getId());
    }

    @Override
    public int update(OperatingActivityDto operatingActivityDto) {
        OperatingActivityEntity entity = new OperatingActivityEntity(operatingActivityDto.getId());
        BeanUtils.copy((Object)operatingActivityDto, (Object)((Object)entity));
        int result = this.operatingActivityDao.update(entity);
        this.cacheClient.remove(this.getCacheKeyById(operatingActivityDto.getId()));
        return result;
    }

    @Override
    public List<Long> findAppIdsByDuibaSecondsKillId(Long duibaSecondsKillId) {
        return this.operatingActivityDao.findAppIdsByDuibaSecondsKillId(duibaSecondsKillId);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSecondsKillActivityId(Long duibaSecondsKillActivityId) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaSecondsKillActivityId(duibaSecondsKillActivityId), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaQuestionAnswerId(Long duibaQuestionAnswerId) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaQuestionAnswerId(duibaQuestionAnswerId), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaQuizzId(Long duibaQuizzId) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaQuizzId(duibaQuizzId), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSeckillId(Long duibaSeckillId) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaSeckillId(duibaSeckillId), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaSecondsKillActivityIdAndDeleted(Long duibaSecondsKillActivityId, Boolean deleted) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaSecondsKillActivityIdAndDeleted(duibaSecondsKillActivityId, deleted), OperatingActivityDto.class);
    }

    @Override
    public void updateStatusByDuibaSecondsKillActivityId(Integer status, Long duibaSecondsKillActivityId) {
        List<Long> ids = this.operatingActivityDao.findIdsByDuibaActivityIdAndType(duibaSecondsKillActivityId, 30);
        this.operatingActivityDao.updateStatusByDuibaSecondsKillActivityId(status, duibaSecondsKillActivityId);
        for (Long id : ids) {
            this.cacheClient.remove(this.getCacheKeyById(id));
        }
    }

    @Override
    public OperatingActivityDto findGameOperatingActivity(Long appId, Long gameConfigDuibaId, Integer gameType) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findGameOperatingActivity(appId, gameConfigDuibaId, gameType)), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findQuestionAnswerOperatingActivity(Long appId, Long activityId) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findQuestionAnswerOperatingActivity(appId, activityId)), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findSecondsKillOperatingActivity(Long appId, Long activityId) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findSecondsKillOperatingActivity(appId, activityId)), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaGameIdAndDeleted(Long appId, Long duibaGameId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndDuibaGameIdAndDeleted(appId, duibaGameId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public ActivityDto findByAppIdLimit(Long appId, Long activityId) {
        return (ActivityDto)BeanUtils.copy((Object)this.operatingActivityDao.findByAppIdLimit(appId, activityId), ActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByAppId(Long appId) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByAppId(appId), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaSecondsKillActivityIdAndDeleted(Long appId, Long duibaSecondsKillActivityId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndDuibaSecondsKillActivityIdAndDeleted(appId, duibaSecondsKillActivityId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findDuibaQuestionAnswerByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        return BeanUtils.copyList(this.operatingActivityDao.findDuibaQuestionAnswerByAppIdAndActivityId(appId, activityIds, type), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findDuibaQuizzByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        return BeanUtils.copyList(this.operatingActivityDao.findDuibaQuizzByAppIdAndActivityId(appId, activityIds, type), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findDuibaSeckillByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        if (CollectionUtils.isEmpty(activityIds)) {
            return Lists.newArrayList();
        }
        return BeanUtils.copyList(this.operatingActivityDao.findDuibaSeckillByAppIdAndActivityId(appId, activityIds, type), OperatingActivityDto.class);
    }

    @Override
    public List<ActivityDto> findOnlineActivity(Map<String, Object> params) {
        return BeanUtils.copyList(this.operatingActivityDao.findOnlineActivity(params), ActivityDto.class);
    }

    @Override
    public List<ActivityDto> findOnlineActivityWithOutTopic(Map<String, Object> params) {
        return BeanUtils.copyList(this.operatingActivityDao.findOnlineActivityWithOutTopic(params), ActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaGuessIdAndDeleted(Long duibaGuessId, Boolean deleted) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaGuessIdAndDeleted(duibaGuessId, deleted), OperatingActivityDto.class);
    }

    @Override
    public List<Long> findAppIdsByDuibaGuessId(Long duibaGuessId) {
        return this.operatingActivityDao.findAppIdsByDuibaGuessId(duibaGuessId);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaNgameId(Long duibaNgameId) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaNgameId(duibaNgameId), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findAllByDuibaGuessId(Long duibaGuessId) {
        return BeanUtils.copyList(this.operatingActivityDao.findAllByDuibaGuessId(duibaGuessId), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findDuibaNgameByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        return BeanUtils.copyList(this.operatingActivityDao.findDuibaNgameByAppIdAndActivityId(appId, activityIds, type), OperatingActivityDto.class);
    }

    @Override
    public List<OperatingActivityDto> findDuibaGuessByAppIdAndActivityId(Long appId, List<Long> activityIds, Integer type) {
        return BeanUtils.copyList(this.operatingActivityDao.findDuibaGuessByAppIdAndActivityId(appId, activityIds, type), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaGuessIdAndDeleted(Long appId, Long duibaGuessId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndDuibaGuessIdAndDeleted(appId, duibaGuessId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaNgameActivityIdAndDeleted(Long appId, Long duibaNgameActivityId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndDuibaNgameActivityIdAndDeleted(appId, duibaNgameActivityId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public OperatingActivityDto findByAppIdAndDuibaGuessActivityIdAndDeleted(Long appId, Long duibaGuessActivityId, Boolean deleted) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.findByAppIdAndDuibaGuessActivityIdAndDeleted(appId, duibaGuessActivityId, deleted)), OperatingActivityDto.class);
    }

    @Override
    public List<Long> findSeckillIdsByActivityId(Long duibaSeckillId) {
        return this.operatingActivityDao.findSeckillIdsByActivityId(duibaSeckillId);
    }

    @Override
    public OperatingActivityDto findById(Long id) {
        return (OperatingActivityDto)BeanUtils.copy((Object)((Object)this.operatingActivityDao.select(id)), OperatingActivityDto.class);
    }

    @Override
    public List<Long> findAppIdsByIds(List<Long> ids) {
        return this.operatingActivityDao.findAppIdsByIds(ids);
    }

    @Override
    public void insertUnique(OperatingActivityDto operatingActivityDto) {
        OperatingActivityEntity entity = new OperatingActivityEntity(true);
        BeanUtils.copy((Object)operatingActivityDto, (Object)((Object)entity));
        this.operatingActivityDao.insert(entity);
        operatingActivityDto.setId(entity.getId());
    }

    @Override
    public int updateVisitTimes(Long operatingActivityId, int offset) {
        int ret = this.operatingActivityDao.updateWin(operatingActivityId, offset);
        this.cacheClient.remove(this.getCacheKeyById(operatingActivityId));
        return ret;
    }

    @Override
    public List<OperatingActivityDto> findByActivityId(Long activityId) {
        return BeanUtils.copyList(this.operatingActivityDao.findByActivityId(activityId), OperatingActivityDto.class);
    }
}

