/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.tools.service;

import cn.com.duiba.service.domain.dataobject.CouponBatchDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.remoteservice.RemoteCouponService;
import cn.com.duiba.service.item.remoteservice.RemoteItemAppSpecifyService;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemKeyStockServcie {
    @Autowired
    private RemoteCouponService remoteCouponService;
    @Autowired
    private RemoteItemAppSpecifyService remoteItemAppSpecifyService;
    @Autowired
    private RemotePreStockService remotePreStockService;

    public Integer findRemaining(ItemKey itemKey) {
        Integer remaining = 0;
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            Long stock;
            Integer specifyRemaining;
            ItemDO item = itemKey.getItem();
            if (item.isNoStock()) {
                return 100000000;
            }
            CouponBatchDO batch = this.remoteCouponService.getCurrentBatch(itemKey);
            remaining = batch != null ? Integer.valueOf(Math.min(item.getRemaining(), batch.getRemaining())) : item.getRemaining();
            if (remaining != null && remaining > 0 && item.isOpTypeItem(3) && (specifyRemaining = this.remoteItemAppSpecifyService.findSpecifyRemaining(item.getId(), itemKey.getApp().getId())) != null && specifyRemaining <= remaining) {
                remaining = specifyRemaining;
            }
            if (remaining != null && remaining > 0 && item.isOpTypeItem(10) && null != (stock = this.remotePreStockService.getPreStock(itemKey.getItem(), itemKey.getApp())) && stock <= (long)remaining.intValue()) {
                remaining = stock.intValue();
            }
        } else if (itemKey.isSelfAppItemMode()) {
            CouponBatchDO batch = this.remoteCouponService.getCurrentBatch(itemKey);
            remaining = batch != null ? Integer.valueOf(Math.min(itemKey.getAppItem().getRemaining(), batch.getRemaining())) : itemKey.getAppItem().getRemaining();
        }
        return remaining;
    }

    public boolean couponBatchCheck(ItemKey itemKey) {
        if ("coupon".equals(itemKey.getItemType())) {
            if ((itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) && itemKey.getItem().getBatchId() == null) {
                return false;
            }
            if (itemKey.isSelfAppItemMode() && itemKey.getAppItem().getBatchId() == null) {
                return false;
            }
            if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
                if (itemKey.getItem().getValidEndDate() != null && new Date().after(itemKey.getItem().getValidEndDate())) {
                    return false;
                }
                if (itemKey.getItem().getAutoOffDate() != null && new Date().after(itemKey.getItem().getAutoOffDate())) {
                    return false;
                }
            } else if (itemKey.isSelfAppItemMode()) {
                if (itemKey.getAppItem().getValidEndDate() != null && new Date().after(itemKey.getAppItem().getValidEndDate())) {
                    return false;
                }
                if (itemKey.getAppItem().getAutoOffDate() != null && new Date().after(itemKey.getAppItem().getAutoOffDate())) {
                    return false;
                }
            }
        }
        return true;
    }
}

