/**
 * Project Name:activity-center-biz
 * File Name:DuibaAdMaterialDaoImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.advert.impl
 * Date:2016年10月9日下午4:28:33
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.dao.advert.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.advert.DuibaAdMaterialDao;
import cn.com.duiba.activity.center.biz.entity.advert.DuibaAdMaterialEntity;

/**
 * ClassName:DuibaAdMaterialDaoImpl <br/>
 * Date:     2016年10月9日 下午4:28:33 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository
public class DuibaAdMaterialDaoImpl extends ActivityBaseDao implements DuibaAdMaterialDao{

    @Override
    public int deleteByPrimaryKey(Long id) {
        return delete("deleteByPrimaryKey",id);
    }

    @Override
    public int insert(DuibaAdMaterialEntity record) {
        return insert("insert",record);
    }

    @Override
    public int insertSelective(DuibaAdMaterialEntity record) {
        return insert("insertSelective",record);
    }

    @Override
    public DuibaAdMaterialEntity selectByPrimaryKey(Long id) {
        return selectOne("selectByPrimaryKey",id);
    }

    @Override
    public List<DuibaAdMaterialEntity> selectByIds(List<Long> ids) {
        Map<String,Object> param = Maps.newHashMap();
        param.put("ids", ids);
        return selectList("selectByIds",param);
    }
    
    @Override
    public int updateByPrimaryKeySelective(DuibaAdMaterialEntity record) {
        return update("updateByPrimaryKeySelective",record);
    }

    @Override
    public int updateByPrimaryKey(DuibaAdMaterialEntity record) {
        return update("updateByPrimaryKey",record);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }

    @Override
    public DuibaAdMaterialEntity selelctByActivity(Long activityId, Integer activityType) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("activityId",activityId);
        params.put("activityType", activityType);
        return selectOne("selectByActivity",params);
    }



}

