package cn.com.duiba.activity.center.biz.dao.direct;

import cn.com.duiba.activity.center.api.dto.direct.ActivityBlackList4DeveloperDto;

import java.util.List;
import java.util.Map;

public interface DeveloperActivityBlackDao {
	
	/**
	 * 单个添加
	 * @param black
	 * 		activityId
	 * 		activityType
	 * 		developerId	
	 * @return
	 * 		id
	 */
	public int  insert(ActivityBlackList4DeveloperDto black);
	/**
	 * 批量添加
	 * @param blacks
	 * 		activityId
	 * 		activityType
	 * 		developerId
	 * @return
	 * 		添加数量 int
	 */
	public int insertList(List<ActivityBlackList4DeveloperDto> blacks);
	
	/**
	 * 根据id获取
	 * @param id
	 * @return
	 */
	public ActivityBlackList4DeveloperDto find(Long id);
	/**
	 * 删除黑名单
	 * @param id
	 * @return
	 */
	public int remove(Long id);
	
	/**
	 * 根据活动id,活动type查询
	 * @param map
	 * @return
	 */
	public List<ActivityBlackList4DeveloperDto> queryByActivity(Map<String, Object> map);
	
	public int queryCountByActivity(Long activityId, Integer activityType);
	/**
	 * 查询存在
	 * @param black
	 * 		activityId
	 * 		activityType
	 * 		developerId
	 * @return
	 * 		count(*)
	 */
	public int query(ActivityBlackList4DeveloperDto black);
	
	/**
	 * 根据开发者ID查询被加入黑名单的活动ID
	 *
	 * @author zhanglihui
	 * @param developerId  开发者id
	 * @param activityType 活动类型
	 * @return
	 * @since JDK 1.6
	 */
	List<Long> queryActivityIdsByDeveloperId(Long developerId, Integer activityType);
}
