package cn.com.duiba.activity.center.biz.dao.direct.impl;

import cn.com.duiba.activity.center.api.dto.direct.DuibaActivityAppSpecifyNewDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.direct.DuibaActivityAppSpecifyNewDao;
import com.alibaba.dubbo.config.annotation.Service;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * Created by suyuanlong on 16/7/20.
 */
@Repository
public class DuibaActivityAppSpecifyNewDaoImpl extends ActivityBaseDao implements DuibaActivityAppSpecifyNewDao {

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }

    @Override
    public DuibaActivityAppSpecifyNewDto findAppSpecifyByActivityIdAndAppIdAndActivityType(Long activityId, Long appId, String activityType) {

        Map<String, Object> map = Maps.newHashMap();
        map.put("relationId", activityId);
        map.put("appId", appId);
        map.put("relationType", activityType);
        return selectOne("findAppSpecifyByActivityIdAndAppIdAndActivityType", map);
    }

    @Override
    public List<DuibaActivityAppSpecifyNewDto> findAppSpecifyByActivityIdAndActivityType(Long activityId, String activityType) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("relationId", activityId);
        map.put("relationType", activityType);
        return selectList("findAppSpecifyByActivityIdAndActivityType", map);
    }

    @Override
    public Long insertAppSpecify(DuibaActivityAppSpecifyNewDto bto) {


        return Long.valueOf(insert("insertAppSpecify", bto));
    }

    @Override
    public int deleteAppSpecifyById(Long id) {
        return delete("deleteAppSpecifyById", id);
    }

    @Override
    public DuibaActivityAppSpecifyNewDto findAppSpecifyById(Long id) {
        return selectOne("findAppSpecifyById", id);
    }
}
