package cn.com.duiba.activity.center.biz.dao.elasticgifts.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.elasticgifts.ElasticGiftsDao;
import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository("ElasticGiftsDao")
public class ElasticGiftsDaoImpl extends ActivityBaseDao implements ElasticGiftsDao {

    @Override
    public List<ElasticGiftsEntity> findPage(int offset, int max, Integer bizCode, Long elasticGiftsId, String title4admin) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("offset", offset);
        paramMap.put("max", max);
        paramMap.put("bizCode", bizCode);
        paramMap.put("elasticGiftsId", elasticGiftsId);
        paramMap.put("title4admin", title4admin);
        return this.selectList("findPage", paramMap);
    }

    @Override
    public Integer findPageCount(Integer bizCode, Long elasticGiftsId, String title4admin) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bizCode", bizCode);
        paramMap.put("elasticGiftsId", elasticGiftsId);
        paramMap.put("title4admin", title4admin);
        return this.selectOne("findPageCount", paramMap);
    }

    @Override
    public int updateStatus(Long id, Integer targetStatus) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("targetStatus", targetStatus);
        return this.update("updateStatus", paramMap);
    }

    @Override
    public int delete(Long id) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        return this.update("delete", paramMap);
    }

    @Override
    public int insert(ElasticGiftsEntity entity) {
        return this.insert("insert", entity);
    }

    @Override
    public int update(ElasticGiftsEntity entity) {
        return this.update("update", entity);
    }

    @Override
    public ElasticGiftsEntity find(Long id) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        return this.selectOne("find", paramMap);
    }

    @Override
    public ElasticGiftsEntity findByIdAndBizCode(Long id, Integer bizCode) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("bizCode", bizCode);
        return this.selectOne("findByIdAndBizCode", paramMap);
    }

    @Override
    public List<ElasticGiftsEntity> findAllByTitle4adminAndBizCode(String text, Integer bizCode) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("text", text);
        paramMap.put("bizCode", bizCode);
        return this.selectList("findAllByTitle4adminAndBizCode", paramMap);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }
}
