package cn.com.duiba.activity.center.biz.dao.hdtool.impl;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.api.dto.advertising.AdActivityDto;
import cn.com.duiba.activity.center.api.dto.advertising.DuibaAdActivityDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.hdtool.DuibaHdtoolDao;
import cn.com.duiba.activity.center.biz.entity.ActivityExtraInfoEntity;
import cn.com.duiba.activity.center.biz.entity.AddActivityEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolAppSpecifyEntity;

/**
 * 兑吧活动工具业务DAO
 */
@Repository
public class DuibaHdtoolDaoImpl extends ActivityBaseDao implements DuibaHdtoolDao {
	
	/**
	 * 查询一天内，需要定时下架的转盘抽奖
	 * @return
	 */
	@Override
	public List<DuibaHdtoolEntity> findAutoOff(){
		Calendar cal1 = Calendar.getInstance();
		cal1.setTime(new Date());
		cal1.add(Calendar.DATE, -1);
		Date startTime = cal1.getTime();
		
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("startTime", startTime);
		paramMap.put("endTime", new Date());
		return selectList("findAutoOff", paramMap);	
	}

	/**
	 * 根据ID查询
	 */
	@Override
	public DuibaHdtoolEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	/**
	 * 活动工具分页列表
	 */
	//Start chaijiangang,管理员后台活动管理页面增加筛选条件,2016/03/30
	//public List<DuibaHdtoolEntity> findDuibaHdToolsList(int offset, int max) {
	@Override
	public List<DuibaHdtoolEntity> findDuibaHdToolsList(Map<String, Object> paramMap) {
        /*Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("offset", offset);
        paramMap.put("max", max);*/
		//End chaijiangang,管理员后台活动管理页面增加筛选条件,2016/03/30
	    
	    //活动工具新增 商业活动类型字段，为兼容老的，没传参数 默认查询普通活动
	    Object type = paramMap.get("activityActionType");
	    if(type==null){
	        paramMap.put("activityActionType",DuibaAdActivityDto.Activity_Action_common );
	    }
		return selectList("findDuibaHdToolsList",paramMap);
	}

	/**
	 * 统计活动工具条数
	 */
	@Override
	public Integer countDuibaHdToolsList(Map<String, Object> queryMap) {
	    //活动工具新增 商业活动类型字段，为兼容老的，没传参数 默认查询普通活动
        Object type = queryMap.get("activityActionType");
        if(type==null){
            queryMap.put("activityActionType",DuibaAdActivityDto.Activity_Action_common );
        }
		return selectOne("countDuibaHdToolsList",queryMap);
	}

	/**
	 * 根据APP查询活动工具
	 */
	@Override
	public List<AddActivityEntity> findAllDuibaHdTools(Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("appId", appId);
		return selectList("findAllDuibaHdTools", paramMap);
	}

	/**
	 * 根据ID集合查询活动工具
	 */
	@Override
	public List<DuibaHdtoolEntity> findAllByIds(List<Long> ids) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("ids", ids);
		return selectList("findAllByIds", paramMap);
	}

	/**
	 * 根据活动ID查询定向
	 */
	@Override
	public List<HdtoolAppSpecifyEntity> findAllSpecifyByHdToolId(Long hdToolId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("hdToolId", hdToolId);
		return selectList("findAllSpecifyByHdToolId", paramMap);
	}

	/**
	 * 根据活动ID或APP查询定向关系
	 */
	@Override
	public HdtoolAppSpecifyEntity findSpecifyByHdToolIdAndApp(Long duibaHdToolId, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaHdToolId", duibaHdToolId);
		paramMap.put("appId", appId);
		return selectOne("findSpecifyByHdToolIdAndApp", paramMap);
	}

	@Override
	public List<HdtoolAppSpecifyEntity> findSpecifyByHdToolIdsAndApp(List<Long> duibaHdToolIds, Long appId){
		if(duibaHdToolIds == null || duibaHdToolIds.isEmpty()){
			return Collections.emptyList();
		}
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaHdToolIds", duibaHdToolIds);
		paramMap.put("appId", appId);
		return selectList("findSpecifyByHdToolIdsAndApp", paramMap);
	}

	/**
	 * 根据ID查询定向关系
	 */
	@Override
	public HdtoolAppSpecifyEntity findSpecifyById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("findSpecifyById", paramMap);
	}
	
	/**
	 * 根据ID查询额外信息
	 */
	@Override
	public ActivityExtraInfoEntity findExtraInfoById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("findExtraInfoById", paramMap);
	}

	/**
	 * @param queryMap
	 * @return
	 */
	@Override
	public Long getCountDuibaHdTool(Map<String, Object> queryMap) {
		return selectOne("getCountDuibaHdTool", queryMap);
	}

	/**
	 * @param queryMap
	 * @return
	 */
	@Override
	public List<DuibaHdtoolEntity> findDuibaToolList(Map<String, Object> queryMap) {
		return selectList("findDuibaToolList", queryMap);
	}

	//from DuibaHdtoolTextChangeDao


	@Override
	public int updateAutoOffDateNull(Long id){
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return update("updateAutoOffDateNull", paramMap);
	}

	/**
	 * 新增兑吧活动工具
	 */
	@Override
	public void insert(DuibaHdtoolEntity duibaHdtoolDto) {
		insert("insert", duibaHdtoolDto);
	}

	/**
	 * 删除兑吧活动
	 */
	@Override
	public int deleteById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return update("deleteById", paramMap);
	}

	/**
	 * 修改兑吧活动工具
	 */
	@Override
	public int update(DuibaHdtoolEntity duibaHdtoolDto) {
		return update("update", duibaHdtoolDto);
	}

	/**
	 * 修改活动工具状态
	 */
	@Override
	public int updateStatus(Long id, Integer status) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("status", status);
		return update("updateStatus", paramMap);
	}

	/**
	 * 删除定向关系
	 */
	@Override
	public int deleteSpecifyById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return delete("deleteSpecifyById", paramMap);
	}

	/**
	 * 添加定向关系
	 */
	@Override
	public void insertSpecify(HdtoolAppSpecifyEntity hdtoolAppSpecifyDO) {
		insert("insertSpecify", hdtoolAppSpecifyDO);
	}

	@Override
	public int updateActivityCategory(long  duibaHdtoolId,long activityCategoryId){
	    Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", duibaHdtoolId);
        paramMap.put("activityCategoryId", activityCategoryId);
	    return update("updateActivityCategory", paramMap);
	}

	/**
     * 根据ID查询标签
     */
	@Override
    public String findTag(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("findTag", paramMap);
    }

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS;
	}

	@Override
	public List<?> findAllSpecifyMap(Map<String, Object> queryMap) {
		return selectList("findAllSpecifyMap",queryMap);
	}

	@Override
	public Integer findAllSpecifyByCredordCount(Map<String, Object> queryMap) {
		return selectOne("findAllSpecifyByCredordCount",queryMap);
	}
}
