package cn.com.duiba.activity.center.biz.dao.manuallottery.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.manuallottery.ManualOrderLotteryDao;
import cn.com.duiba.activity.center.biz.entity.manual.ManualLotteryOrderEntity;

@Repository
public class ManualOrderLotteryDaoImpl extends ActivityBaseDao implements ManualOrderLotteryDao {

    @Override
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        Map<String, Object> map = new HashMap<String, Object>(2);
        map.put("consumerId", consumerId);
        map.put("operatingActivityId", operatingActivityId);
        return selectOne("countByConsumerIdAndOperatingActivityId", map);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId,
                                                                  Date start, Date end) {
        Map<String, Object> map = new HashMap<String, Object>(4);
        map.put("consumerId", consumerId);
        map.put("operatingActivityId", operatingActivityId);
        map.put("start", start);
        map.put("end", end);
        return selectOne("countByConsumerIdAndOperatingActivityIdAndDate", map);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        Map<String, Object> map = new HashMap<String, Object>(2);
        map.put("consumerId", consumerId);
        map.put("operatingActivityId", operatingActivityId);
        return selectOne("countFreeByConsumerIdAndOperatingActivityId", map);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId,
                                                                      Date start, Date end) {
        Map<String, Object> map = new HashMap<String, Object>(4);
        map.put("consumerId", consumerId);
        map.put("operatingActivityId", operatingActivityId);
        map.put("start", start);
        map.put("end", end);
        return selectOne("countFreeByConsumerIdAndOperatingActivityIdAndDate", map);
    }

    @Override
    public List<ManualLotteryOrderEntity> findAllOpenManualLotteryByCondition(Map<String, Object> paramMap) {
        return selectList("findAllOpenManualLotteryByCondition", paramMap);
    }

    @Override
    public Long findAllOpenManualLotteryCount(Map<String, Object> paramMap) {
        return selectOne("findAllOpenManualLotteryCount", paramMap);
    }

    @Override
    public List<ManualLotteryOrderEntity> findWardList(Long operatingActivityId) {
        Map<String, Object> map = new HashMap<String, Object>(1);
        map.put("operatingActivityId", operatingActivityId);
        return selectList("findWardList", map);
    }

    @Override
    public List<ManualLotteryOrderEntity> findNoWardList(Map<String, Object> paramMap) {
        return selectList("findNoWardList", paramMap);
    }

    @Override
    public Long findNoWardListCount(Map<String, Object> paramMap) {
        return selectOne("findNoWardListCount", paramMap);
    }

    @Override
    public List<ManualLotteryOrderEntity> findStartOpenListByIds(Map<String, Object> paramMap) {
        return selectList("findStartOpenListByIds", paramMap);
    }

    @Override
    public int updateAward(Long id, Long activityId, Date date) {
        Map<String, Object> map = new HashMap<String, Object>(3);
        map.put("activityId", activityId);
        map.put("id", id);
        map.put("date", date);
        return update("updateAward", map);
    }

    @Override
    public ManualLotteryOrderEntity randomFindManualLottery(Map<String, Object> paramMap) {
        return selectOne("randomFindManualLottery", paramMap);
    }

    @Override
    public void updateNoAwardList(Map<String, Object> paramMap) {
        update("updateNoAwardList", paramMap);
    }

    @Override
    public List<ManualLotteryOrderEntity> findAllNoAwardList(Map<String, Object> paramMap) {
        return selectList("findAllNoAwardList", paramMap);
    }

    @Override
    public List<ManualLotteryOrderEntity> findAllByIds(List<Long> ids) {
        Map<String, Object> map = new HashMap<String, Object>(1);
        map.put("ids", ids);
        return selectList("findAllByIds", map);
    }

    @Override
    public ManualLotteryOrderEntity findByOrderId(Long orderId) {
        Map<String, Object> map = new HashMap<String, Object>(1);
        map.put("orderId", orderId);
        return selectOne("findByOrderId", map);
    }

    @Override
    public ManualLotteryOrderEntity findByAppAndDeveloperBizId(Long appId, String bizId) {
        Map<String, Object> map = new HashMap<String, Object>(2);
        map.put("appId", appId);
        map.put("bizId", bizId);
        return selectOne("findByAppAndDeveloperBizId", map);
    }

    @Override
    public void insert(ManualLotteryOrderEntity manualLotteryOrderEntity) {
        insert("insert", manualLotteryOrderEntity);
    }

    @Override
    public void update(ManualLotteryOrderEntity manualLotteryOrderEntity) {
        update("update", manualLotteryOrderEntity);
    }

    @Override
    public ManualLotteryOrderEntity find(Long id) {
        return selectOne("find", id);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}
