package cn.com.duiba.activity.center.biz.dao.ngame.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameAppSpecifyDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameAppSpecifyEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DuibaNgameAppSpecifyDaoImpl extends ActivityBaseDao implements DuibaNgameAppSpecifyDao {

	@Override
	public List<DuibaNgameAppSpecifyEntity> findByGameId(Long id) {
		return selectList("findByGameId", id);
	}

	@Override
	public void delete(Long id) {
		delete("delete", id);
	}

	@Override
	public void addBatch(List<DuibaNgameAppSpecifyEntity> list) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("list", list);
		insert("addBatch", params);
	}

	@Override
	public void add(DuibaNgameAppSpecifyEntity gameAppSpecifyDO) {
		insert("add",gameAppSpecifyDO);
	}

	@Override
	public DuibaNgameAppSpecifyEntity findByGameConfigAndAppId(Long appId, Long duibaGameId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("appId", appId);
		paramMap.put("duibaGameId", duibaGameId);
		return selectOne("findByGameConfigAndAppId", paramMap);
	}

	public List<DuibaNgameAppSpecifyEntity> findByGameConfigsAndAppId(Long appId, List<Long> duibaGameIds){
		if(duibaGameIds.isEmpty()){
			return Collections.emptyList();
		}
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("appId", appId);
		paramMap.put("duibaGameIds", duibaGameIds);
		return selectList("findByGameConfigsAndAppId", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.NGAME;
	}
}
