package cn.com.duiba.activity.center.biz.dao.quizz.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzBrickDao;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzBrickEntity;

@Repository
public class DuibaQuizzBrickDaoImpl extends ActivityBaseDao implements DuibaQuizzBrickDao {

    @Override
    public DuibaQuizzBrickEntity find(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("find", paramMap);
    }

    @Override
    public String getBrickContentById(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("getBrickContentById", paramMap);
    }

    @Override
    public DuibaQuizzBrickEntity findNoContent(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("findNoContent", paramMap);
    }
    
    @Override
	public void insert(DuibaQuizzBrickEntity duibaQuestionAnswerBrick) {
		insert("insert", duibaQuestionAnswerBrick);
	}

	@Override
	public void update4Admin(Long id, String title, String content, String md5) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("title", title);
		paramMap.put("content", content);
		paramMap.put("md5", md5);
		update("update4Admin", paramMap);
	}

	@Override
	public DuibaQuizzBrickEntity findByTitle(String title) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("title", title);
		return selectOne("findByTitle", paramMap);
	}

	@Override
	public void open(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		update("open", paramMap);
	}

	@Override
	public void disable(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		update("disable", paramMap);
	}

	@Override
	public List<DuibaQuizzBrickEntity> findPage(Map<String, Object> paramMap) {
		return selectList("findPage", paramMap);
	}

	@Override
	public Long findPageCount() {
		return selectOne("findPageCount");
	}

	@Override
	public List<DuibaQuizzBrickEntity> findAll() {
		return selectList("findAll");
	}

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.QUIZZ;
    }
}
