package cn.com.duiba.activity.center.biz.dao.rob_category;

import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryEntity;

import java.util.List;

/**
 * 描述:今日必抢分类dao接口定义
 *
 * @author :sunchangji
 * @create :2016-10-17 11:02
 */
public interface RobCategoryDao {

    /**
     * 获取全部分类
     *
     * @return
     */
    List<RobCategoryEntity> getAllCategory();

    /**
     * 根据分类名称或者分类标题分页查询分类
     *
     * @param name     分类名称
     * @param title    分类标题
     * @param offset   分页开始
     * @param pageSize 页距
     * @return
     */
    List<RobCategoryEntity> getPageRobCategory(String name, String title, int offset, int pageSize);

    /**
     * 根据分类名称或者标题查询总条数
     *
     * @param name
     * @param title
     * @return
     */
    int countByNameAndTitle(String name, String title);

    /**
     * 根据分类id集合查询分类
     *
     * @param ids 分类id集合
     * @return
     */
    List<RobCategoryEntity> getRobCategoryByIds(List<Long> ids);


    /**
     * 添加分类
     *
     * @return 新增id
     */
    Long insertRobCategory(RobCategoryEntity robCategoryEntity);

    /**
     * 更新分类
     *
     * @param id    分类id
     * @param name  分类名称
     * @param title 分类标题
     * @return
     */
    int updateRobCategory(Long id, String name, String title);

    /**
     * 根据主键物理删除分类
     *
     * @param id 分类id
     * @return
     */
    int deleteById(Long id);

    /**
     * 根据分类id的几个查询分类信息
     *
     * @param categoryIdList 分类id的集合
     * @return
     */
    List<RobCategoryEntity> getRobCategorysByIds(List<Long> categoryIdList);

    /**
     * 根据分类id查询分类
     *
     * @param id 分类id
     * @return
     */
    RobCategoryEntity getCategoryById(Long id);
}
