package cn.com.duiba.activity.center.biz.kafka;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/7/18.
 */
@Service
public class GuessMQSend {
    private static Logger log = LoggerFactory.getLogger(GuessMQSend.class);

    @Autowired
    private MessageService messageService;

    @Autowired
    private TopicConstant topicConstant;

    public void guessSendDataSync(final Long consumerId, final Long guessOrderId) {

        try {
            DataSyncMessage message = new DataSyncMessage();
            message.setConsumerId(consumerId);
            message.setSubOrderId(guessOrderId);

            log.info("guessSendDataSync : consumerId: " + consumerId + "  guessOrderId: " + guessOrderId);
            {
                messageService.sendMsg(topicConstant.getTopicGuessDataSync(), message);
            }
        } catch (Exception e) {
            log.error("guess   send message is error ", e);
        }

    }

}
