package cn.com.duiba.activity.center.biz.remoteservice.impl.game;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOrdersDto;
import cn.com.duiba.activity.center.api.remoteservice.game.RemoteDuibaQuestionAnswerOrdersService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerOrdersService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/6/1.
 */
@Service
public class RemoteDuibaQuestionAnswerOrdersServiceImpl implements RemoteDuibaQuestionAnswerOrdersService {
    @Resource
    private DuibaQuestionAnswerOrdersService duibaQuestionAnswerOrdersService;

    @Override
    public DuibaQuestionAnswerOrdersDto insert(DuibaQuestionAnswerOrdersDto order) {
        duibaQuestionAnswerOrdersService.insert(order);
        return order;
    }

    @Override
    public void updateStatusToConsumeSuccess(Long id) {
        duibaQuestionAnswerOrdersService.updateStatusToConsumeSuccess(id);
    }

    @Override
    public DuibaQuestionAnswerOrdersDto find(Long id) {
        return duibaQuestionAnswerOrdersService.find(id);
    }

    @Override
    public void updateStatusToConsumeFail(Long id, String error4admin, String error4developer, String error4consumer) {
        duibaQuestionAnswerOrdersService.updateStatusToConsumeFail(id, error4admin, error4developer, error4consumer);
    }

    @Override
    public void updateStatusToSuccess(Long id) {
        duibaQuestionAnswerOrdersService.updateStatusToSuccess(id);
    }

    @Override
    public void updateDeveloperBizId(Long questionOrderId, String bizId) {
        duibaQuestionAnswerOrdersService.updateDeveloperBizId(questionOrderId, bizId);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return duibaQuestionAnswerOrdersService.countByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return duibaQuestionAnswerOrdersService.countByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return duibaQuestionAnswerOrdersService.countFreeByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return duibaQuestionAnswerOrdersService.countFreeByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public void updateExchangeStatusToFail(Long questionOrderId, String error4admin, String error4developer, String error4consumer) {
        duibaQuestionAnswerOrdersService.updateExchangeStatusToFail(questionOrderId, error4admin, error4developer, error4consumer);
    }

    @Override
    public void updateMainOrderId(Long questionOrderId, Long mainOrderId, String mainOrderNum) {
        duibaQuestionAnswerOrdersService.updateMainOrderId(questionOrderId, mainOrderId, mainOrderNum);
    }

    @Override
    public int updateExchangeStatusToOverdue(Long questionOrderId, String error4admin, String error4developer, String error4consumer) {
        return duibaQuestionAnswerOrdersService.updateExchangeStatusToOverdue(questionOrderId, error4admin, error4developer, error4consumer);
    }

    @Override
    public int updateExchangeStatusToSucess(Long questionOrderId, String error4admin, String error4developer, String error4consumer) {
        return duibaQuestionAnswerOrdersService.updateExchangeStatusToSucess(questionOrderId, error4admin, error4developer, error4consumer);
    }

    @Override
    public int updateExchangeStatusToWait(Long questionOrderId, String error4admin, String error4developer, String error4consumer) {
        return duibaQuestionAnswerOrdersService.updateExchangeStatusToWait(questionOrderId, error4admin, error4developer, error4consumer);
    }

    @Override
    public int doTakePrize(Long questionOrderId) {
        return duibaQuestionAnswerOrdersService.doTakePrize(questionOrderId);
    }

    @Override
    public void rollbackTakePrize(Long questionOrderId) {
        duibaQuestionAnswerOrdersService.rollbackTakePrize(questionOrderId);
    }

    @Override
    public List<Long> findOverdueOrder() {
        return duibaQuestionAnswerOrdersService.findOverdueOrder();
    }

    @Override
    public List<DuibaQuestionAnswerOrdersDto> findByIds(List<Long> questionIds) {
        return duibaQuestionAnswerOrdersService.findByIds(questionIds);
    }

    @Override
    public void updatePrizeInfo(DuibaQuestionAnswerOrdersDto questionOrdersDO) {
        duibaQuestionAnswerOrdersService.updatePrizeInfo(questionOrdersDO);
    }

    @Override
    public void updateScore(Long orderId, Integer rightCount) {
        duibaQuestionAnswerOrdersService.updateScore(orderId, rightCount);
    }

    @Override
    public DuibaQuestionAnswerOrdersDto findByAppAndDeveloperBizId(Long appId, String bizId) {
        return duibaQuestionAnswerOrdersService.findByAppAndDeveloperBizId(appId, bizId);
    }

    @Override
    public List<DuibaQuestionAnswerOrdersDto> findQuestionOrderLimit50(Long appId, Long activityId) {
        return duibaQuestionAnswerOrdersService.findQuestionOrderLimit50(appId, activityId);
    }

    @Override
    public int updateLuckPrizeNone(DuibaQuestionAnswerOrdersDto order) {
        return duibaQuestionAnswerOrdersService.updateLuckPrizeNone(order);
    }

    @Override
    public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(List<Long> ids) {
        return duibaQuestionAnswerOrdersService.countFailByOperatingActivityIds(ids);
    }

    @Override
    public List<DuibaQuestionAnswerOrdersDto> findByLimit(Map<String, Object> queryMap) {
        return duibaQuestionAnswerOrdersService.findByLimit(queryMap);
    }

    @Override
    public Long totalCount(Map<String, Object> queryMap) {
        return duibaQuestionAnswerOrdersService.totalCount(queryMap);
    }

}
