package cn.com.duiba.activity.center.biz.remoteservice.impl.plugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickDto;
import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.api.remoteservice.plugin.RemoteActivityPluginService;
import cn.com.duiba.activity.center.biz.service.activity_brick.PopupActivityBrickService;
import cn.com.duiba.activity.center.biz.service.plugin.ActivityPluginService;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.wolf.dubbo.DubboResult;

/** 
 * ClassName:RemoteActivityPluginServiceImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月13日 下午4:36:19 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
@Service
public class RemoteActivityPluginServiceImpl implements
		RemoteActivityPluginService {
	@Resource
	private ActivityPluginService activityPluginService;
	@Resource
	private PopupActivityBrickService popupActivityBrickService;
	
	@Override
	public DubboResult<List<ActivityPluginDto>> findActivityPluginInfoList() {
		//查询所有开启
		Map<String, Object> paramMap =new HashMap<String, Object>();
		paramMap.put("status", ActivityPluginDto.STATUS_OPEN);
		return DubboResult.successResult(activityPluginService.findActivityPluginInfoList(paramMap));
	}

	@Override
	public DubboResult<PopupActivityBrickDto> findBrickById(Long id) {
		return DubboResult.successResult(popupActivityBrickService.findById(id));
	}

	@Override
	public DubboResult<ActivityPluginDto> findById(Long id) {
		return DubboResult.successResult(activityPluginService.findById(id));
	}

	@Override
	public DubboResult<String> createOrder(Long consumerId, String transfer,
			String ip, String description, String ua, String os,
			ActivityPluginDto pluDto) {
		//产生订单号
		try{
			String orderNum = activityPluginService.createOrder(consumerId,transfer,ip,description,ua,os,pluDto);
			return DubboResult.successResult(orderNum);
		}catch (Exception e){
			if(e instanceof StatusException){
				return DubboResult.failResult(((StatusException)e).getMessage());
			}else{
				return DubboResult.failResult(e.getMessage());
			}
		}
	}

}
