package cn.com.duiba.activity.center.biz.remoteservice.impl.rob.category;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.api.remoteservice.rob.category.RemoteRobActivityService;
import cn.com.duiba.activity.center.biz.service.rob.RobActivityService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobConfigService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 功能描述:今日必抢分类活动相关操作service实现类
 *
 * @author sunchangji
 * @date 2016/10/19
 */
@Service
public class RemoteRobActivityServiceImpl implements RemoteRobActivityService {

    @Autowired
    private RobActivityService robActivityService;
    @Autowired
    private TodayRobConfigService todayRobConfigService;

    @Override
    public DubboResult<Boolean> insertTodayRobActivity(Long activityId, List<Long> categoryIdList) {
        TodayRobConfigDto todayRobConfig = todayRobConfigService.find(activityId);
        if (todayRobConfig == null) {
            return DubboResult.failResult("活动不存在");
        }
        return DubboResult.successResult(robActivityService.insertTodayRobActivity(activityId, categoryIdList));
    }

    @Override
    public DubboResult<Boolean> updateTodayRobActivity(Long activityId, List<Long> categoryIdList) {
        TodayRobConfigDto todayRobConfig = todayRobConfigService.find(activityId);
        if (todayRobConfig == null) {
            return DubboResult.failResult("活动不存在");
        }
        return DubboResult.successResult(robActivityService.updateTodayRobActivity(activityId, categoryIdList));
    }

    @Override
    public DubboResult<Boolean> delTodayRobActivityById(Long robActivityId) {
        return DubboResult.successResult(robActivityService.delTodayRobActivityById(robActivityId));
    }

    @Override
    public DubboResult<List<Long>> getCategoryIdsByActivityId(Long activityId) {
        return DubboResult.successResult(robActivityService.getCategoryIdsByActivityId(activityId));
    }


}
