package cn.com.duiba.activity.center.biz.remoteservice.impl.rob.category;

import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryBarAppRelationDto;
import cn.com.duiba.activity.center.api.remoteservice.rob.category.RemoteRobCategoryBarAppRelationService;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarAppRelationEntity;
import cn.com.duiba.activity.center.biz.service.rob.RobCategoryBarAppRelationService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * 功能描述: 功能描述:分类栏与应用关联表操作接口实现类
 * (也称分类栏定向实体)
 *
 * @author sunchangji
 * @date 2016/10/19
 */
@Service
public class RemoteRobCategoryBarAppRelationServiceImpl implements RemoteRobCategoryBarAppRelationService {

    @Autowired
    private RobCategoryBarAppRelationService robCategoryBarAppRelationService;

    @Override
    public DubboResult<List<RobCategoryBarAppRelationDto>> getRobCategoryBarAppList() {
        return DubboResult.successResult(robCategoryBarAppRelationService.getRobCategoryBarAppList());
    }

    @Override
    public DubboResult<Boolean> deleteById(Long barId) {
        return DubboResult.successResult(robCategoryBarAppRelationService.deleteById(barId));
    }

    @Override
    public DubboResult<Boolean> batchDeleteById(List<Long> barIds) {
        return DubboResult.successResult(robCategoryBarAppRelationService.batchDeleteById(barIds));
    }

    @Override
    public DubboResult<Boolean> batchInsertBarAppRelation(List<RobCategoryBarAppRelationDto> batchList) {
        if (CollectionUtils.isEmpty(batchList))
            return DubboResult.failResult("新增定向参数为空");
        //新增前检查是否该appId已经被定向到别的分类栏中，如果已经被定向，则不能新增,一个app只能被定向到一个分类栏中
        for (RobCategoryBarAppRelationDto robCategoryBarAppRelationDto : batchList) {
            Map<Long, String> appIdAndAppNameMap = robCategoryBarAppRelationDto.getAppIdAndAppNameMap();
            if (CollectionUtils.isEmpty(appIdAndAppNameMap))
                return DubboResult.failResult("新增定向参数中app数据为空");
            for (Map.Entry<Long, String> entry : appIdAndAppNameMap.entrySet()) {
                RobCategoryBarAppRelationEntity relationEntity = robCategoryBarAppRelationService.getByAppId(entry.getKey());
                if (relationEntity != null)
                    return DubboResult.failResult("appId=[" + entry.getKey() + "]的应用已经被定向到分类栏barId=[" + relationEntity.getBarId() + "]中");
            }
        }
        //批量插入新纪录
        robCategoryBarAppRelationService.batchInsertBarAppRelation(batchList);
        return DubboResult.successResult(true);
    }

    @Override
    public DubboResult<Boolean> batchUpdateBarAppRelation(List<RobCategoryBarAppRelationDto> batchList) {
        return DubboResult.successResult(robCategoryBarAppRelationService.batchUpdateBarAppRelation(batchList));
    }

    @Override
    public DubboResult<Boolean> batchDeleteBarAppRelation(List<Long> appIds) {
        return DubboResult.successResult(robCategoryBarAppRelationService.batchDeleteBarAppRelation(appIds));
    }

}
