/**
 * Project Name:activity-center-biz
 * File Name:ActivityCategoryService.java
 * Package Name:cn.com.duiba.activity.center.biz.service
 * Date:2016年6月7日上午8:56:44
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.service;

import java.util.List;

import cn.com.duiba.activity.center.biz.entity.ActivityCategoryEntity;

/**
 * ClassName:ActivityCategoryService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年6月7日 上午8:56:44 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface ActivityCategoryService {
    /**
     * 创建一个活动分类
     *
     * @author xuhengfei
     * @param name
     * @param content 
     * @return
     * @since JDK 1.6
     */
    Long createCategory(String name, String content);
    /**
     * 修改活动分类的皮肤
     *
     * @author xuhengfei
     * @param id
     * @param name
     * @param content
     * @return
     * @since JDK 1.6
     */
    Boolean editCategoryContent(long id,String name, String content);
    /**
     * 启用一个活动分类
     *
     * @author xuhengfei
     * @param id
     * @return
     * @since JDK 1.6
     */
    Boolean enableCategory(long id);
    /**
     * 禁用一个活动分类
     *
     * @author xuhengfei
     * @param id
     * @return
     * @since JDK 1.6
     */
    Boolean disableCategory(long id);
    /**
     * 查询所有的活动分类
     *
     * @author xuhengfei
     * @return
     * @since JDK 1.6
     */
    List<ActivityCategoryEntity> findAll();
    
    /**
     * 根据id集合查询
     * findByIds:(这里用一句话描述这个方法的作用). <br/>
     * @author liyang
     * @param ids
     * @return
     * @since JDK 1.6
     */
    List<ActivityCategoryEntity> findByIds(List<Long> ids);
    /**
     * 查询默认的分类
     *
     * @author xuhengfei
     * @return
     * @since JDK 1.6
     */
    ActivityCategoryEntity findDefaultCategory();
	ActivityCategoryEntity findById(long id);
	/**
	 * 删除活动分类（子页面）
	 *
	 * @author zhanglihui
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	Boolean deleteCategory(long id);
	
	/**
	 * 根据appId查询开发者后台显示的子页面列表
     * 1. 子页面必须开启
     * 2. 子页面若开启定向，appId必须在定向列表内
	 *
	 * @author zhanglihui
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
    List<ActivityCategoryEntity> findCategoryByAppId(Long appId);
}

