/**
 * Project Name:activity-center-biz
 * File Name:DuibaAdMaterialService.java
 * Package Name:cn.com.duiba.activity.center.biz.service.advert
 * Date:2016年10月9日下午4:56:28
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.service.advert;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.constant.MemcachedSpace;
import cn.com.duiba.activity.center.biz.dao.advert.DuibaAdMaterialDao;
import cn.com.duiba.activity.center.biz.entity.advert.DuibaAdMaterialEntity;
import cn.com.duiba.wolf.cache.CacheClient;

/**
 * ClassName:DuibaAdMaterialService <br/>
 * Date:     2016年10月9日 下午4:56:28 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository
public class DuibaAdMaterialService {
    
    @Resource
    private DuibaAdMaterialDao duibaAdMaterialDao;
    @Resource
    private CacheClient cacheClient;
    
    /**
     * find:根据id查找. <br/>
     *
     * @author wubo
     * @param id
     * @return
     * @since JDK 1.6
     */
    public DuibaAdMaterialEntity find(Long id){
        return this.duibaAdMaterialDao.selectByPrimaryKey(id);
    }
    
    /**
     * 
     * findByIds:批量查询. <br/>
     *
     * @author wubo
     * @param List<Long> ids
     * @return
     * @since JDK 1.6
     */
    public List<DuibaAdMaterialEntity> findByIds(List<Long> ids){
        return this.duibaAdMaterialDao.selectByIds(ids);
    }
    
    /**
     * add:添加. <br/>
     * @author wubo
     * @param entity
     * @return
     * @since JDK 1.6
     */
    public Long add(DuibaAdMaterialEntity entity){
        Date date = new Date();
        entity.setGmtCreate(date);
        entity.setGmtModified(date);
        this.duibaAdMaterialDao.insertSelective(entity);
        return entity.getId();
    }
    /**
     * update:更新 <br/>
     *
     * @author wubo
     * @param entity
     * @return
     * @since JDK 1.6
     */
    public boolean update(DuibaAdMaterialEntity entity){
        boolean rs;
        if(entity.getId()==null){
            rs = false;
        }else{
            
            removeKeyById(entity.getId());
            int num = this.duibaAdMaterialDao.updateByPrimaryKeySelective(entity);
            if(num==1){
                rs = true;
            }else{
                rs = false;
            }
        }
        return rs;
    }
    
    /**
     * 
     * delete:删除 <br/>
     * @author wubo
     * @param id
     * @return
     * @since JDK 1.6
     */
    public boolean delete(Long id){
        removeKeyById(id);
        
        boolean rs;
        int num = this.duibaAdMaterialDao.deleteByPrimaryKey(id);
        if(num==1){
            rs = true;
        }else{
            rs = false;
        }
        return rs;
    }
    
    /**
     * findByActivity:根据活动id,活动type 查找. <br/>
     *
     * @author wubo
     * @param activityId
     * @param activityType
     * @return entitys
     * 
     */
    public DuibaAdMaterialEntity findByActivity(Long activityId,Integer activityType){
        DuibaAdMaterialEntity entity = this.cacheClient.get(keyGenerator(activityId, activityType));
        if(entity==null){
            entity = this.duibaAdMaterialDao.selelctByActivity(activityId, activityType);
            this.cacheClient.set(keyGenerator(activityId, activityType), entity, 1000);
        }
        return entity;
    }
    private void removeKeyById(Long id){
        DuibaAdMaterialEntity old = this.duibaAdMaterialDao.selectByPrimaryKey(id);
        //清理缓存
        if(old!=null){
            this.cacheClient.remove(keyGenerator(old.getActivityId(), old.getActivityType()));
        }
    }
    
    private String keyGenerator(Long activityId,Integer activityType){
        return MemcachedSpace.MS_ADMATERIAL_CACHE+"activityId"+"-"+activityType;
    }
}

