package cn.com.duiba.activity.center.biz.service.chaos;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;

import java.util.List;

public interface ActPreStockSerivce {
    /*
 * 根据奖品类型及id查询活动预分配定向库存
 * @param relationPrizeId
 * @param relationType
 * @param appId
 * @return
 */
    public ActPreStockDto findPreStockByApp(Long relationPrizeId, String relationType, Long appId);

    /*
     * 根据奖品类型及id查询活动预分配共享库存
     * @param relationPrizeId
     * @param relationType
     * @return
     */
    public ActPreStockDto findPreStockByShare(Long relationPrizeId, String relationType);

    /*
     * 加锁查询
     * @param id
     * @return
     */
    public ActPreStockDto findByLock(Long id);

    /*
     * 减库存
     * @param id
     * @return
     */
    public int decrementRemaining(Long id);

    /*
     * 返库存 
     * @param id
     * @return
     */
    public int incrementRemaining(Long id);

    /*
     * 加库存 
     * @param id
     * @param addRemaining
     * @return
     */
    public int addRemainingById(Long id, Long addRemaining);

    /* 
     * 减库存
     * @param id
     * @param subRemaining
     * @return
     */
    public int subRemainingById(Long id, Long subRemaining);

    /*
     * 插入记录
     * @param actPreStockDO
     */
    public void insert(ActPreStockDto actPreStockDO);

    /*
     * 更新记录 
     * @param actPreStockDO
     */
    public int update(ActPreStockDto actPreStockDO);


    public List<ActPreStockDto> findActStockByConfigId(Long configId, String relationType);



    public void addAppActPreStock(Long configId, Long prizeId,
                                  Long quantity, String name,String relationType,Long appId);
    /**
     * 新增共享预分配库存
     * @param configId
     * @param prizeId
     * @param quantity
     * @param name
     * @param relationType
     */
    public void addShareActPreStock(Long configId,Long prizeId,Long quantity,String name,String relationType);

    /**
     * 刷新共享预分配库存
     * @param prizeId
     * @param relationType
     * @param appId
     * @param quantity
     * @param name
     * @return
     */
    public int refreshActPreStock(Long prizeId,String relationType,Long appId,Long quantity,String name);

    /**
     * 删除活动，则删除
     * @param configId
     * @return
     */
    public int deleteActStock(Long configId,String relationType);

    /**
     * 删除活动的奖品
     * @param configId
     * @param prizeId
     * @param relationType
     * @return
     */
    public int deleteActPrizeStock(Long configId,Long prizeId,String relationType);

    /**
     * 删除appId
     * @param configId
     * @param prizeId
     * @param relationType
     * @param appId
     * @return
     * @throws Exception
     */
    public int deleteActStockAppId(Long prizeId,String relationType,Long appId) ;

    /**
     * 查询预分配库存
     * @param prizeId
     * @param relationType
     * @param appId
     * @return
     */
    public ActPreStockDto findPreStock(Long prizeId,String relationType,Long appId);

    /**
     * 查询预分配库存,根据配置id
     * @param configId
     * @param relationType
     * @return
     */
    public List<ActPreStockDto> findPreStock(Long configId,String relationType);
    
    public ActPreStockDto find(Long id);
}
