package cn.com.duiba.activity.center.biz.service.chaos.impl;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.chaos.ActPreStockDao;
import cn.com.duiba.activity.center.biz.entity.chaos.ActPreStockEntity;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.wolf.utils.BeanUtils;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

import java.util.List;

/**
 * Created by yansen on 16/6/22.
 */
@Service
public class ActPreStockServiceImpl implements ActPreStockSerivce {
    @Resource
    private ActPreStockDao actPreStockDao;

    @Override
    public ActPreStockDto findPreStockByApp(Long relationPrizeId, String relationType, Long appId) {
        return BeanUtils.copy(actPreStockDao.findPreStockByApp(relationPrizeId, relationType, appId),ActPreStockDto.class);
    }

    @Override
    public ActPreStockDto findPreStockByShare(Long relationPrizeId, String relationType) {
        return BeanUtils.copy(actPreStockDao.findPreStockByShare(relationPrizeId, relationType),ActPreStockDto.class);
    }

    @Override
    @Transactional(DsConstants.DATABASE_CREDITS_ACTIVITY)
    public ActPreStockDto findByLock(Long id) {
        return BeanUtils.copy(actPreStockDao.findByLock(id),ActPreStockDto.class);
    }

    @Override
    public int decrementRemaining(Long id) {
        return actPreStockDao.decrementRemaining(id);
    }

    @Override
    public int incrementRemaining(Long id) {
        return actPreStockDao.incrementRemaining(id);
    }

    @Override
    public int addRemainingById(Long id, Long addRemaining) {
        return actPreStockDao.addRemainingById(id, addRemaining);
    }

    @Override
    public int subRemainingById(Long id, Long subRemaining) {
        return actPreStockDao.subRemainingById(id, subRemaining);
    }

    @Override
    public void insert(ActPreStockDto actPreStockDO) {
        ActPreStockEntity entity=new ActPreStockEntity(true);
        BeanUtils.copy(actPreStockDO,entity);
        actPreStockDao.insert(entity);
        actPreStockDO.setId(entity.getId());
    }

    @Override
    public int update(ActPreStockDto actPreStockDO) {
        return actPreStockDao.update(BeanUtils.copy(actPreStockDO,ActPreStockEntity.class));
    }

    @Override
    public int deleteActStock(Long configId, String relationType) {
        return actPreStockDao.deleteActStock(configId, relationType);
    }

    @Override
    public int deleteActPrizeStock(Long configId, Long prizeId, String relationType) {
        return actPreStockDao.deleteActPrizeStock(configId, prizeId, relationType);
    }

    @Override
    public int deleteActStockAppId(Long prizeId, String relationType, Long appId) {
        return actPreStockDao.deleteActStockAppId(prizeId, relationType, appId);
    }

    @Override
    public List<ActPreStockDto> findActStockByConfigId(Long configId, String relationType) {
        return BeanUtils.copyList(actPreStockDao.findActStockByConfigId(configId, relationType),ActPreStockDto.class);
    }


    @Override
    public void addAppActPreStock(Long configId, Long prizeId, Long quantity,
                                  String name, String relationType, Long appId) {

        ActPreStockDto preStock = new ActPreStockDto(true);

        preStock.setAppId(appId);
        preStock.setDeleted(0);
        preStock.setRelationConfigId(configId);
        preStock.setRelationPrizeId(prizeId);
        preStock.setPrizeQuantity(quantity);
        preStock.setPrizeName(name);
        preStock.setRelationType(relationType);
        actPreStockDao.insert(BeanUtils.copy(preStock,ActPreStockEntity.class));
    }

    @Override
    public void addShareActPreStock(Long configId, Long prizeId,
                                    Long quantity, String name,String relationType) {

        ActPreStockDto preStock = new ActPreStockDto(true);

        preStock.setAppId(0L);
        preStock.setDeleted(0);
        preStock.setRelationConfigId(configId);
        preStock.setRelationPrizeId(prizeId);
        preStock.setPrizeQuantity(quantity);
        preStock.setPrizeName(name);
        preStock.setRelationType(relationType);
        actPreStockDao.insert(BeanUtils.copy(preStock,ActPreStockEntity.class));
    }

    @Override
    public int refreshActPreStock(Long prizeId, String relationType,
                                  Long appId, Long quantity, String name) {
        ActPreStockEntity stock = null;
        if(appId.equals(0L)){
            stock = actPreStockDao.findPreStockByShare(prizeId, relationType);
        }else{
            stock = actPreStockDao.findPreStockByApp(prizeId, relationType, appId);
        }

        if(null != stock){
            stock.setPrizeQuantity(quantity);
            stock.setPrizeName(name);
            actPreStockDao.update(stock);
        }
        return 0;
    }

    @Override
    public ActPreStockDto findPreStock(Long prizeId, String relationType,
                                      Long appId) {
        ActPreStockDto stock = null;
        if(appId.equals(0L)){
            stock = BeanUtils.copy(actPreStockDao.findPreStockByShare(prizeId, relationType),ActPreStockDto.class);
        }else{
            stock = BeanUtils.copy(actPreStockDao.findPreStockByApp(prizeId, relationType, appId),ActPreStockDto.class);
        }
        return stock;
    }

    @Override
    public List<ActPreStockDto> findPreStock(Long configId, String relationType) {
        List<ActPreStockDto> stocks = BeanUtils.copyList(actPreStockDao.findActStockByConfigId(configId, relationType),ActPreStockDto.class);
        return stocks;
    }

    @Override
    @Transactional(DsConstants.DATABASE_CREDITS_ACTIVITY)
    public ActPreStockDto find(Long id) {
        return BeanUtils.copy(actPreStockDao.find(id),ActPreStockDto.class);
    }
}
