package cn.com.duiba.activity.center.biz.service.direct;

import cn.com.duiba.activity.center.api.dto.direct.ActivityBlackList4DeveloperDto;

import java.util.List;

public interface DeveloperActBlackService {
	
	/**
	 * 批量加入黑名单
	 * (已加入黑名单的会过滤)
	 * @param blacks
	 * 		类参数包括:activityId,activityType,developerId
	 * @return
	 * 		返回类参数包括:id,activityId,activityType,developerId
	 * 返回加入黑名单成功的类,不包括过滤的
	 */
	public List<ActivityBlackList4DeveloperDto> createBlackList(List<ActivityBlackList4DeveloperDto> blacks);


	/**
	 *
	 * @param black
	 * @return
     */
	public  ActivityBlackList4DeveloperDto insertActivityBalack(ActivityBlackList4DeveloperDto black);
	
	/**
	 * 删除黑名单
	 * @param id
	 * @return
	 *		true:成功,false:失败
	 */
	public Boolean removeBlack(Long id);
	
	/**
	 * 根据活动id,活动类型分页查询
	 * @param activityId:活动id
	 * @param activityType:活动类型
	 * @param offset:开始值
	 * @param max:每页条数
	 * @return
	 */
	public List<ActivityBlackList4DeveloperDto> queryByActivity(Long activityId,
												  Integer activityType, Integer offset, Integer max);
	
	/**
	 * 根据活动id,活动类型,统计总数
	 * @param activityId
	 * @param activityType
	 * @return
	 */
	public Integer queryCountByActivity(Long activityId, Integer activityType);
	
	/**
	 * 查询
	 * @param black
	 * @return
	 */
	public Integer query(ActivityBlackList4DeveloperDto black);
	
	/**
	 * 清除缓存
	 * 当数据变动时,删除相关缓存
	 * @param black
	 */
	public void removeBlackCache(ActivityBlackList4DeveloperDto black);
	
	/**
	 * 设置黑名单缓存
	 * (300s)
	 * @param black
	 * 		BLACK-开发者id-活动id-活动type 表示key
	 * @param value
	 * 		true 表示已加入黑名单, false 表示未加入黑名单
	 */
	public void setBlackCache(ActivityBlackList4DeveloperDto black, Boolean value);
	
	/**
	 * 查询黑名单缓存
	 * @author zp
	 * @param black
	 * @return
	 * @since JDK 1.6
	 */
	public Boolean getBlackCache(ActivityBlackList4DeveloperDto black);
	
	/**
	 * 根据开发者ID查询被加入黑名单的活动ID
	 *
	 * @author zhanglihui
	 * @param developerId
	 * @param activityType
	 * @return
	 * @since JDK 1.6
	 */
	List<Long> queryActivityIdsByDeveloperId(Long developerId, Integer activityType);
}
