package cn.com.duiba.activity.center.biz.service.plugin.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.biz.dao.plugin.ActivityPluginDao;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerPluginService;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent.ActivityOrdersEventType;
import cn.com.duiba.activity.center.biz.service.plugin.ActivityPluginService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;

/** 
 * ClassName:ActivityPluginServiceImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月11日 下午4:21:45 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
@Service
public class ActivityPluginServiceImpl implements ActivityPluginService {

	private static Logger log = LoggerFactory.getLogger(ActivityPluginServiceImpl.class);
	@Autowired
	private ActivityPluginDao activityPluginDao;
	@Autowired
	private RemoteConsumerService remoteConsumerService;
	@Autowired 
	private RemoteActivityOrderService remoteActivityOrderService;
	@Autowired
	private ConsumerPluginService consumerPluginService;

	@Override
	public ActivityPluginDto createActivityPluginInfo(ActivityPluginDto activityPluginDto) {
		return activityPluginDao.createActivityPluginInfo(activityPluginDto);
	}

	@Override
	public Integer updateActivityPluginInfo(ActivityPluginDto activityPluginDto) {
		return activityPluginDao.updateActivityPluginInfo(activityPluginDto);
	}

	@Override
	public ActivityPluginDto findById(Long id) {
		return activityPluginDao.findById(id);
	}

	@Override
	public Integer OpenStatus(Long id,Integer value) {
		return activityPluginDao.OpenStatus(id,value);
	}

	@Override
	public List<ActivityPluginDto> findActivityPluginInfoList(Map<String, Object> map) {
		return activityPluginDao.findActivityPluginInfoList(map);
	}

	@Override
	public Long findPageCount(Map<String, Object> paramMap) {
		return activityPluginDao.findPageCount(paramMap);
	}

	@Override
	public Integer dellActivityPlugin(Long id) {
		return activityPluginDao.dellActivityPlugin(id);
	}

	@Override
	public int updateAutoOffDateNull(Date autoOffDate, Long id) {
		return activityPluginDao.updateAutoOffDateNull(autoOffDate, id);
	}

	@Override
	public String createOrder(Long consumerId, String transfer, String ip,
			String description, String ua, String os, ActivityPluginDto pluDto) {
		//查询用户信息
		ConsumerDO consumer = remoteConsumerService.find(consumerId);
		//产生订单号
		String orderNum = createOrder(consumer, pluDto, ip);
		ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(orderNum).getResult();
		//用于统计
		DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEventType.OnOrderCreate, order));
		consumerPluginService.asyncConsumerPlug(consumerId, orderNum,transfer,ip,ua,os,pluDto);
		return orderNum;
	}
	//生成订单
	private String createOrder(ConsumerDO consumer, ActivityPluginDto pluDto,String ip) {
		ActivityOrderDto orderDto = new ActivityOrderDto();
		orderDto.setConsumerId(consumer.getId());
		orderDto.setAppId(consumer.getAppId());
		orderDto.setPartnerUserId(consumer.getPartnerUserId());
		orderDto.setDuibaActivityId(pluDto.getId());
		orderDto.setActivityType(ActivityOrderDto.TypePlugin);
		orderDto.setConsumeCredits(0L);
		orderDto.setExchangeStatus(ActivityOrderDto.ExchangeWait);
		orderDto.setConsumeCreditsStatus(ActivityOrderDto.ConsumeCreditsSuccess);
		orderDto.setIp(ip);
		Date now = new Date();
		orderDto.setGmtCreate(now);
		orderDto.setGmtModified(now);
		String orderNum = null;
		try{
			orderNum = remoteActivityOrderService.createOrder(orderDto).getResult();
		}catch(Exception e){
			log.error("创建订单失败",e);
			throw e;
		}
		return orderNum;
	}
}