package cn.com.duiba.activity.center.biz.service.rob.impl;

import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.rob.TodayRobConfigDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryActivityRelationDao;
import cn.com.duiba.activity.center.biz.service.rob.RobActivityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 功能描述:今日必抢分类活动相关操作service实现类
 *
 * @author sunchangji
 * @date 2016/10/19
 */
@Service
public class RobActivityServiceImpl implements RobActivityService {

    @Autowired
    private TodayRobConfigDao todayRobConfigDao;
    @Autowired
    private RobCategoryActivityRelationDao robCategoryActivityRelationDao;

    @Override
    @Transactional(value = DsConstants.DATABASE_CREDITS_ACTIVITY)
    public Boolean insertTodayRobActivity(Long activityId, List<Long> categoryIdList) {
        if (!CollectionUtils.isEmpty(categoryIdList)) {
            for (Long categoryId : categoryIdList) {
                robCategoryActivityRelationDao.insertRobCategoryActivityRelation(categoryId, activityId, 0);
            }
        }

        return true;
    }

    @Override
    public Boolean updateTodayRobActivity(Long activityId, List<Long> categoryIdList) {
        robCategoryActivityRelationDao.deleteByActivityId(activityId);
        if (!CollectionUtils.isEmpty(categoryIdList)) {
            for (Long categoryId : categoryIdList) {
                robCategoryActivityRelationDao.insertRobCategoryActivityRelation(categoryId, activityId, 0);
            }
        }
        return true;
    }

    @Override
    @Transactional(value = DsConstants.DATABASE_CREDITS_ACTIVITY)
    public Boolean delTodayRobActivityById(Long robActivityId) {
        Boolean isSuccess = todayRobConfigDao.del(robActivityId);
        if (!isSuccess)
            return false;
        robCategoryActivityRelationDao.deleteByActivityId(robActivityId);
        return true;
    }

    @Override
    public List<Long> getCategoryIdsByActivityId(Long activityId) {
        List<Long> categoryIds = robCategoryActivityRelationDao.getCategoryIdsByActivityId(activityId);
        if (categoryIds == null) {
            categoryIds = new ArrayList<>();
        }
        return categoryIds;
    }


}
