package cn.com.duiba.activity.center.biz.service.rob.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.duiba.activity.center.api.enums.PushStatusEnum;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.rob.TodayRobSeckillConfigDao;
import cn.com.duiba.activity.center.biz.dao.rob.TodayRobSeckillDao;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillConfigEntity;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillEntity;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobSeckillService;
/**
 * 
 * Author ：zhengjy <br/>
 * Create Time：2016年9月30日 上午8:59:10 <br/>
 */
@Service
public class TodayRobSeckillServiceImpl implements TodayRobSeckillService{
	@Autowired
	private TodayRobSeckillDao todayRobSeckillDao;
	
	@Autowired
	private TodayRobSeckillConfigDao todayRobSeckillConfigDao;

	@Override
	public List<TodayRobSeckillConfigEntity> findSeckillConfigs(
			Long todayRobSeckillId) {
		return todayRobSeckillConfigDao.selectSeckillConfigs(todayRobSeckillId);
	}

	@Override
	public TodayRobSeckillEntity findSeckillById(Long todayRobSeckillId) {
		return todayRobSeckillDao.selectSeckillById(todayRobSeckillId);
	}

	@Override
	public List<TodayRobSeckillEntity> findTodayRobSeckillList(int pageNum,
			int pageSize) {
		return todayRobSeckillDao.selectTodayRobSeckillList(pageNum, pageSize);
	}

	@Override
	public Long findTodayRobSeckillCount() {
		return todayRobSeckillDao.selectTodayRobSeckillCount();
	}
	
	@Transactional(value=DsConstants.DATABASE_CREDITS_ACTIVITY)
	@Override
	public Boolean delTodayRobSeckill(long todayRobSeckillId) {
		todayRobSeckillDao.deleteTodayRobSeckill(todayRobSeckillId);
		List<Long> list = new ArrayList<Long>(1);
		list.add(todayRobSeckillId);
		todayRobSeckillConfigDao.deleteSeckillConfigBatch(list);
		return true;
	}

	@Override
	public Boolean enableTodayRobSeckill(long todayRobSeckillId, boolean enable) {
		return todayRobSeckillDao.updateTodayRobSeckill(todayRobSeckillId, enable);
	}

    @Override
    public TodayRobSeckillConfigEntity findPushedActivity(Long activityId) {
        return todayRobSeckillConfigDao.selectPushedActivity(activityId);
    }
	@Override
	public Boolean saveSeckillConfigBatch(List<TodayRobSeckillConfigEntity> insertParamList) {
		return todayRobSeckillConfigDao.insertSeckillConfigBatch(insertParamList);
	}

	@Override
	public Boolean updateSeckillConfigBatch(List<TodayRobSeckillConfigEntity> updateParamList) {
		return todayRobSeckillConfigDao.updateSeckillConfigBatch(updateParamList);
	}

	@Override
	public Boolean delSeckillConfigBatch(List<Long> delIds) {
		return todayRobSeckillConfigDao.deleteSeckillConfigBatch(delIds);
	}

	@Override
	public List<TodayRobSeckillConfigEntity> findSeckillConfigByIdss(
			List<Long> todayRobSeckillIds) {
		return todayRobSeckillConfigDao.selectSeckillConfigByIdss(todayRobSeckillIds);
	}

	@Override
	public Boolean saveSeckill(TodayRobSeckillEntity trc) {
		return todayRobSeckillDao.insertSeckill(trc);
	}

	@Override
	public Boolean updateSeckill(TodayRobSeckillEntity trc) {
		return todayRobSeckillDao.updateSeckill(trc);
	}

    @Override
    public void updatePushStatus(Long todayRobSeckillConfigId, PushStatusEnum pushStatus) {
        Date pushTime = null;
        if(pushStatus == PushStatusEnum.EXEC){
            pushTime = new Date();
        }
        todayRobSeckillConfigDao.updatePushStatusAndTime(todayRobSeckillConfigId, pushStatus.getCode(), pushTime);
    }

    @Override
    public void disableActivityBeforeDate(Date date) {
        todayRobSeckillDao.disableActivityBeforeDate(date);
    }

    @Override
    public List<TodayRobSeckillConfigEntity> findUnsuccessPushList() {
        return todayRobSeckillConfigDao.findUnsuccessPushList();
    }

    @Override
    public TodayRobSeckillEntity findSeckillBeforeNow() {
        List<TodayRobSeckillEntity> list = todayRobSeckillDao.selectSeckillBeforeTime(new Date(), 1);
        if(CollectionUtils.isEmpty(list)){
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<TodayRobSeckillEntity> findSeckillAfterNow(int limit) {
        return todayRobSeckillDao.selectSeckillAfterTime(new Date(), limit);
    }

    @Override
    public List<Long> findEnableTodayRobSeckillIds() {
        return todayRobSeckillDao.findEnableTodayRobSeckillIds();
    }
}
