package cn.com.duiba.activity.center.biz.tools.service;

import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.constant.Environment;
import cn.com.duiba.activity.center.biz.constant.MemcachedSpace;
import cn.com.duiba.activity.center.biz.utils.MemLock;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.wolf.cache.CacheClient;

/**
 * 频繁兑换限制
 * 一个用户的兑换时间间隔必须大于3秒
 *
 */
@Service
public class FrequentExchangeLimitService {
	
	private static Logger log = LoggerFactory.getLogger(FrequentExchangeLimitService.class);

	private final String APP_NAMESPACE = "app_trading";
	@Autowired
    private CacheClient memcachedClient;
	
	/**
	 * 是否能够通过验证
	 * @param consumer
	 * @return
	 */
	public boolean canPass(ConsumerDO consumer){
		if (Environment.isDaily()) {
			return true;
		}
		Long time=(Long)memcachedClient.get(MemcachedSpace.MS_LAST_EXCHANGE+"-"+consumer.getId());
		if(time!=null){
			if(time>(new Date().getTime()-3*1000L)){
				return false;
			}
		}
		return true;
	}
	
	public void updateLast(ConsumerDO consumer){
		memcachedClient.set(MemcachedSpace.MS_LAST_EXCHANGE+"-"+consumer.getId(),new Date().getTime(),10);
	}
	
	/**
	 * 用户频繁兑换限制
	 * @param consumerId 用户ID
	 * @param s 秒
	 */
	public boolean canPass(Long consumerId, int s){
		if (Environment.isDaily()) {
			return true;
		}
		try {
			if (Environment.isDaily()) {
				return true;
			}
			String key = MemcachedSpace.MS_LAST_EXCHANGE+"-"+consumerId+"-lottery";
			Long time=(Long)memcachedClient.get(key);
			if(time!=null){
				if(time>(new Date().getTime()-s*1000L)){
					return false;
				}
			}else{
				memcachedClient.set(key,new Date().getTime(),2);
			}
		} catch (Exception e) {
			log.error("canPass",e);
		}
		return true;
	}
	
	 public Integer getTodayTradingCount(Long appId){
        String key = APP_NAMESPACE+appId;
        Integer appItemCounter = 0;
        try {
            appItemCounter = (Integer) memcachedClient.get(key);
            if(appItemCounter==null){
                appItemCounter = 0;
            }
        } catch (Exception e) {
            log.error("error:",e);
        }
        return appItemCounter;
	}
	 
	 /**
     * 锁住奖项
     */
	@Deprecated
    public MemLock lockPrize(Long activityId,String activityType, Long prizeId){
		//此方法不提供全局锁，影响发券效率，待删除
        MemLock memLock = new MemLock();
        memLock.setLocked(true);
        memLock.setTicket(String.valueOf(System.currentTimeMillis()));
        return memLock;
    }
    
    /**
     * 解锁奖项
     */
	@Deprecated
    public void unlockPrize(Long activity,String activityType, Long prizeId){
    	
    }
}
