/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.bo.game;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOptionsDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionStockDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionStockManualChangeDto;
import cn.com.duiba.activity.center.api.dto.game.QuestionStockConsumeDto;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionStockConsumeService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionStockManualChangeService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionStockService;
import cn.com.duiba.service.exception.BusinessException;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DuibaQuestionStockBo {
    private Logger log = Logger.getLogger(DuibaQuestionStockBo.class);
    @Resource
    private DuibaQuestionStockConsumeService duibaQuestionStockConsumeService;
    @Autowired
    private DuibaQuestionStockService duibaQuestionStockService;
    @Autowired
    private DuibaQuestionStockManualChangeService duibaQuestionStockManualChangeService;

    @Transactional(value="creditsGame")
    public void consumeStock(Long questionOptionId, String questionOrderId) throws BusinessException {
        DuibaQuestionStockDto questionStock = this.duibaQuestionStockService.findRemaining(questionOptionId, "duiba");
        if (questionStock.getStock() > 0) {
            int quantity = 1;
            int ret = this.duibaQuestionStockService.subStock(questionStock.getId(), quantity);
            if (ret < 1) {
                throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            QuestionStockConsumeDto questionStockConsumer = new QuestionStockConsumeDto();
            questionStockConsumer.setBizId(questionOrderId);
            questionStockConsumer.setAction("pay");
            questionStockConsumer.setQuestionStockId(questionStock.getId());
            questionStockConsumer.setQuantity(Integer.valueOf(quantity));
            questionStockConsumer.setGmtCreate(new Date());
            questionStockConsumer.setGmtModified(new Date());
            this.duibaQuestionStockConsumeService.insert(questionStockConsumer);
        }
    }

    @Transactional(value="creditsGame")
    public void paybackStock(String questionOrderId) throws BusinessException {
        QuestionStockConsumeDto payConsume = this.duibaQuestionStockConsumeService.findByBizId(questionOrderId, "pay");
        if (payConsume != null) {
            int quantity = payConsume.getQuantity();
            int ret = this.duibaQuestionStockService.addStock(payConsume.getQuestionStockId(), quantity);
            if (ret < 1) {
                throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            QuestionStockConsumeDto questionStockConsumer = new QuestionStockConsumeDto();
            questionStockConsumer.setBizId(questionOrderId);
            questionStockConsumer.setAction("back");
            questionStockConsumer.setQuestionStockId(payConsume.getQuestionStockId());
            questionStockConsumer.setQuantity(Integer.valueOf(quantity));
            questionStockConsumer.setGmtCreate(new Date());
            questionStockConsumer.setGmtModified(new Date());
            this.duibaQuestionStockConsumeService.insert(questionStockConsumer);
        }
    }

    @Transactional(value="creditsGame")
    public void updateStockByOptions(DuibaQuestionAnswerOptionsDto option) {
        Integer addOrSub = DuibaQuestionAnswerOptionsDto.ADD;
        int diff = 0;
        DuibaQuestionStockDto stockDO = this.duibaQuestionStockService.findByQuestionOptionId(option.getId());
        if (stockDO == null) {
            stockDO = new DuibaQuestionStockDto();
            stockDO.setQuestionOptionId(option.getId());
            stockDO.setRelationType("duiba");
            stockDO.setStock(option.getNewOptionCount());
            this.duibaQuestionStockService.add(stockDO);
            diff = option.getNewOptionCount();
            addOrSub = DuibaQuestionStockManualChangeDto.ADD;
            if (diff != 0) {
                DuibaQuestionStockDto newStock = this.duibaQuestionStockService.findByQuestionOptionId(option.getId());
                DuibaQuestionStockManualChangeDto stockManualChangeDO = new DuibaQuestionStockManualChangeDto();
                stockManualChangeDO.setQuestionStockId(stockDO.getId());
                stockManualChangeDO.setBeforeStock(Integer.valueOf(0));
                stockManualChangeDO.setAfterStock(newStock.getStock());
                stockManualChangeDO.setChangeKind(addOrSub);
                stockManualChangeDO.setChangeQuantity(Integer.valueOf(Math.abs(diff)));
                this.duibaQuestionStockManualChangeService.add(stockManualChangeDO);
            }
        }
    }

    @Transactional(value="creditsGame")
    public void updateStockByOptions(DuibaQuestionAnswerOptionsDto option, DuibaQuestionAnswerOptionsDto old) throws BusinessException {
        Integer addOrSub = DuibaQuestionStockManualChangeDto.ADD;
        int diff = 0;
        DuibaQuestionStockDto stockDO = this.duibaQuestionStockService.findByQuestionOptionId(option.getId());
        if (stockDO == null) {
            stockDO = new DuibaQuestionStockDto();
            stockDO.setQuestionOptionId(option.getId());
            stockDO.setRelationType("duiba");
            stockDO.setStock(option.getNewOptionCount());
            this.duibaQuestionStockService.add(stockDO);
            diff = option.getNewOptionCount();
            addOrSub = DuibaQuestionAnswerOptionsDto.ADD;
        } else {
            Integer nowCount;
            Integer oldStock = stockDO.getStock();
            diff = (oldStock == null ? 0 : oldStock) - ((nowCount = option.getNewOptionCount()) == null ? 0 : nowCount);
            if (diff == 0) {
                return;
            }
            stockDO.setStock(Integer.valueOf(diff));
            int result = 0;
            if (diff > 0) {
                addOrSub = DuibaQuestionStockManualChangeDto.SUB;
                result = this.duibaQuestionStockService.updateStockSub(stockDO.getId(), stockDO.getStock(), stockDO.getRelationType());
                if (result != 1) {
                    this.log.error((Object)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                    throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                }
            } else {
                addOrSub = DuibaQuestionStockManualChangeDto.ADD;
                result = this.duibaQuestionStockService.updateStockAdd(stockDO.getId(), Math.abs(stockDO.getStock()), stockDO.getRelationType());
                if (result != 1) {
                    this.log.error((Object)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                    throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                }
            }
            if (diff != 0) {
                DuibaQuestionStockDto newStock = this.duibaQuestionStockService.findByQuestionOptionId(option.getId());
                DuibaQuestionStockManualChangeDto stockManualChangeDO = new DuibaQuestionStockManualChangeDto();
                stockManualChangeDO.setQuestionStockId(stockDO.getId());
                stockManualChangeDO.setBeforeStock(oldStock);
                stockManualChangeDO.setAfterStock(newStock.getStock());
                stockManualChangeDO.setChangeKind(addOrSub);
                stockManualChangeDO.setChangeQuantity(Integer.valueOf(Math.abs(diff)));
                this.duibaQuestionStockManualChangeService.add(stockManualChangeDO);
            }
        }
    }
}

